/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.net;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.http.MultipartFormDataContent;
import fm.audiobox.core.AudioBoxClient;
import fm.audiobox.core.config.Configuration;
import fm.audiobox.core.models.MediaFile;
import fm.audiobox.core.models.MediaFileWrapper;
import fm.audiobox.core.net.NetworkProgressListener;
import fm.audiobox.core.utils.MD5Checksum;
import fm.audiobox.core.utils.MediaContent;
import fm.audiobox.core.utils.PlainTextContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload {
    private static final Logger logger = LoggerFactory.getLogger(Upload.class);
    private static final String UPLOAD_PATH = "/api/v1/upload";
    private static final String MAGIC_UPLOAD_HEADER = "x-uploading-md5";
    private File file;
    private NetworkProgressListener listener;
    private AudioBoxClient audioBoxClient;
    private State state = State.ready;

    public Upload(AudioBoxClient audioBoxClient, File file, NetworkProgressListener listener) {
        this.file = file;
        this.listener = listener;
        this.audioBoxClient = audioBoxClient;
    }

    public NetworkProgressListener getListener() {
        return this.listener;
    }

    public void setListener(NetworkProgressListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaFile start() throws IOException, IllegalStateException {
        if (this.state != State.ready) {
            throw new IllegalStateException("Upload is already started or completed.");
        }
        this.state = State.started;
        try {
            MediaContent fileContent = new MediaContent(URLConnection.guessContentTypeFromName(this.file.getAbsolutePath()), this.file);
            if (this.getListener() != null) {
                fileContent.setUploadProgressListener(this.getListener());
            }
            HttpHeaders headers = null;
            try {
                String md5 = MD5Checksum.checkSum(new FileInputStream(this.file));
                headers = new HttpHeaders();
                headers.set(MAGIC_UPLOAD_HEADER, (Object)md5);
            }
            catch (NoSuchAlgorithmException e) {
                logger.warn("Unable to perform magic upload due to lack of MD5 algorithm. Proceeding with whole upload process.");
            }
            PlainTextContent pathContent = new PlainTextContent(this.file.getAbsolutePath());
            MultipartFormDataContent multipart = new MultipartFormDataContent();
            multipart.addPart(new MultipartContent.Part((HttpContent)pathContent), "remotePath", null);
            multipart.addPart(new MultipartContent.Part((HttpContent)fileContent), "files[]", this.file.getName());
            HttpResponse rsp = this.audioBoxClient.doRequestToChannel("POST", UPLOAD_PATH, (HttpContent)multipart, null, Configuration.Channels.upload, headers);
            MediaFile mediaFile = rsp != null && rsp.isSuccessStatusCode() ? ((MediaFileWrapper)rsp.parseAs(MediaFileWrapper.class)).getMediaFile() : null;
            return mediaFile;
        }
        finally {
            this.state = State.completed;
        }
    }

    private static enum State {
        ready,
        started,
        completed;

    }
}

