/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Checksum {
    private static final Logger logger = LoggerFactory.getLogger(MD5Checksum.class);

    public static String checkSum(InputStream is) throws NoSuchAlgorithmException {
        String checksum = null;
        try {
            int numOfBytesRead;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            byte[] buffer = new byte[8192];
            while ((numOfBytesRead = is.read(buffer)) > 0) {
                md.update(buffer, 0, numOfBytesRead);
            }
            byte[] hash = md.digest();
            checksum = new String(Hex.encodeHex((byte[])hash));
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
        }
        return checksum;
    }
}

