/*
 * Decompiled with CFR 0.152.
 */
package fm.audiobox.core.utils;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ProgressInputStream
extends FileInputStream {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final long maxNumBytes;
    private volatile long totalNumBytesRead;
    public static final String TOTAL_NUM_BYTE_READ = "totalNumBytesRead";

    public ProgressInputStream(File in, long maxNumBytes) throws FileNotFoundException {
        super(in);
        this.maxNumBytes = maxNumBytes;
    }

    public long getMaxNumBytes() {
        return this.maxNumBytes;
    }

    public long getTotalNumBytesRead() {
        return this.totalNumBytesRead;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.updateProgress(1L);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return (int)this.updateProgress(super.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return (int)this.updateProgress(super.read(b, off, len));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.updateProgress(super.skip(n));
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private long updateProgress(long numBytesRead) {
        if (numBytesRead > 0L) {
            long oldTotalNumBytesRead = this.totalNumBytesRead;
            this.totalNumBytesRead += numBytesRead;
            this.propertyChangeSupport.firePropertyChange(TOTAL_NUM_BYTE_READ, oldTotalNumBytesRead, this.totalNumBytesRead);
        }
        return numBytesRead;
    }
}

