/*
 * Decompiled with CFR 0.152.
 */
package fm.last.commons.test;

import fm.last.commons.lang.units.JedecByteUnit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public final class LastAssertions {
    public static final String TEST_DB_SUFFIX = "_unittest";

    private LastAssertions() {
    }

    public static void assertTestDatabase(DataSource dataSource) throws SQLException {
        Connection connection = null;
        String dbName = null;
        try {
            connection = dataSource.getConnection();
            dbName = connection.getCatalog();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        if (!dbName.endsWith(TEST_DB_SUFFIX)) {
            throw new IllegalArgumentException("Database provided was " + dbName + " but tests must run against a database who's name ends with " + TEST_DB_SUFFIX);
        }
    }

    public static void assertFileEquals(File file1, File file2) throws IOException {
        LastAssertions.assertFileEquals(null, file1, file2);
    }

    public static void assertFileEquals(String message, File expectedFile, File actualFile) throws IOException {
        LastAssertions.assertFileEquals(message, expectedFile, null, actualFile, null);
    }

    public static void assertFileEquals(String message, File expectedFile, Charset expectedFileEncoding, File actualFile, Charset actualFileEncoding) throws IOException {
        long actualFileLength;
        boolean equal = true;
        long expectedFileLength = expectedFile.length();
        equal = expectedFileLength != (actualFileLength = actualFile.length()) ? false : LastAssertions.fileBytesEqual(expectedFile, actualFile);
        if (!equal) {
            if (message == null) {
                message = "";
            }
            if (Math.max(expectedFileLength, actualFileLength) < JedecByteUnit.MEGABYTES.toBytes(1L)) {
                expectedFileEncoding = LastAssertions.resolveToDefault(expectedFileEncoding);
                actualFileEncoding = LastAssertions.resolveToDefault(actualFileEncoding);
                throw new ComparisonFailure(message, FileUtils.readFileToString((File)expectedFile, (Charset)expectedFileEncoding), FileUtils.readFileToString((File)actualFile, (Charset)actualFileEncoding));
            }
            Assert.fail((String)(expectedFile + " not equal to " + actualFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean fileBytesEqual(File expectedFile, File actualFile) throws IOException {
        boolean bl;
        int readExpected;
        int readActual;
        BufferedInputStream expected = null;
        BufferedInputStream actual = null;
        try {
            expected = new BufferedInputStream(new FileInputStream(expectedFile));
            actual = new BufferedInputStream(new FileInputStream(actualFile));
            while (true) {
                if ((readActual = ((InputStream)actual).read()) == (readExpected = ((InputStream)expected).read())) break block4;
                bl = false;
                break;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(expected);
            IOUtils.closeQuietly(actual);
            throw throwable;
        }
        {
            block4: {
                IOUtils.closeQuietly((InputStream)expected);
                IOUtils.closeQuietly((InputStream)actual);
                return bl;
            }
            if (readExpected != -1 && readActual != -1) continue;
        }
        IOUtils.closeQuietly((InputStream)expected);
        IOUtils.closeQuietly((InputStream)actual);
        return true;
    }

    private static Charset resolveToDefault(Charset charset) {
        if (charset == null) {
            return Charset.defaultCharset();
        }
        return charset;
    }

    public static void assertFilesNotEqual(File expectedFile, File actualFile) throws IOException {
        LastAssertions.assertFilesNotEqual(null, expectedFile, actualFile);
    }

    public static void assertFilesNotEqual(String message, File file1, File file2) throws IOException {
        boolean equalsFailed = false;
        try {
            LastAssertions.assertFileEquals(file1, file2);
        }
        catch (AssertionError e) {
            equalsFailed = true;
        }
        if (!equalsFailed) {
            Assert.fail((String)message);
        }
    }

    public static void assertValues(String expectedValue, Object[] values) {
        for (Object value : values) {
            Assert.assertEquals((Object)expectedValue, (Object)value);
        }
    }

    public static void assertFilesEquivalent(File expected, File actual) throws IOException {
        LastAssertions.assertFilesEquivalent(expected, null, actual, null);
    }

    public static void assertFilesEquivalent(File expected, Charset expectedFileEncoding, File actual, Charset actualFileEncoding) throws IOException {
        int actualLineCount;
        expectedFileEncoding = LastAssertions.resolveToDefault(expectedFileEncoding);
        actualFileEncoding = LastAssertions.resolveToDefault(actualFileEncoding);
        List expectedLines = FileUtils.readLines((File)expected, (Charset)expectedFileEncoding);
        List actualLines = FileUtils.readLines((File)actual, (Charset)actualFileEncoding);
        int expectedLineCount = expectedLines.size();
        Collection difference = expectedLineCount >= (actualLineCount = actualLines.size()) ? CollectionUtils.subtract((Collection)expectedLines, (Collection)actualLines) : CollectionUtils.subtract((Collection)actualLines, (Collection)expectedLines);
        Assert.assertEquals((String)("Unexpected difference: " + difference), (long)0L, (long)difference.size());
    }
}

