/*
 * Decompiled with CFR 0.152.
 */
package fm.last.commons.test.file;

import fm.last.commons.test.file.DataFolder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractDataFolder
implements DataFolder {
    static final String FILE_SEPARATOR_REPLACEMENT = Matcher.quoteReplacement(File.separator);
    static final String PACKAGE_DELIMITER_PATTERN = Pattern.quote(".");
    File folder;

    AbstractDataFolder() {
    }

    @Override
    public File getFolder() throws IOException {
        if (!this.folder.exists()) {
            throw new FileNotFoundException(this.folder.getAbsolutePath());
        }
        if (!this.folder.canRead()) {
            throw new IOException("Cannot read '" + this.folder.getAbsolutePath() + "'");
        }
        if (!this.folder.isDirectory()) {
            throw new IOException("Path is not a directory '" + this.folder.getAbsolutePath() + "'");
        }
        return this.folder;
    }

    @Override
    public File getFile(String relativePath) throws IOException {
        return new File(this.getFolder(), relativePath);
    }

    @Override
    public String getAbsolutePath(String relativePath) throws IOException {
        return this.internalGetAbsolutePath(relativePath);
    }

    @Override
    public URI getUri(String relativePath) throws IOException {
        try {
            return new URI("file://" + this.internalGetAbsolutePath(relativePath));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private String internalGetAbsolutePath(String relativePath) throws IOException {
        return new File(this.getFolder(), relativePath).getAbsolutePath();
    }
}

