/*
 * Decompiled with CFR 0.152.
 */
package fm.last.commons.test.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class TemporaryFolder
implements MethodRule {
    private File folder;

    public final Statement apply(final Statement base, FrameworkMethod method, Object target) {
        Throwable caught;
        try {
            this.create();
            caught = null;
        }
        catch (Throwable e) {
            caught = e;
        }
        final Throwable toRethrow = caught;
        return new Statement(){

            public void evaluate() throws Throwable {
                if (toRethrow != null) {
                    throw toRethrow;
                }
                try {
                    base.evaluate();
                }
                finally {
                    TemporaryFolder.this.delete();
                }
            }
        };
    }

    public void create() throws IOException {
        this.folder = File.createTempFile("junit", "");
        this.folder.delete();
        this.folder.mkdir();
    }

    public File newFile(String first, String ... others) throws IOException {
        List<String> elements = this.mergeElements(first, others);
        File file = this.applyElements(elements);
        if (!this.folder.equals(file.getParentFile())) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        return file;
    }

    public File newFolder(String first, String ... others) {
        List<String> elements = this.mergeElements(first, others);
        File file = this.applyElements(elements);
        file.mkdirs();
        return file;
    }

    public File getRoot() {
        return this.folder;
    }

    public void delete() {
        this.recursiveDelete(this.folder);
    }

    private void recursiveDelete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File each : files) {
                this.recursiveDelete(each);
            }
        }
        file.delete();
    }

    private File applyElements(List<String> elements) {
        File file = this.folder;
        for (String element : elements) {
            file = new File(file, element);
        }
        return file;
    }

    private List<String> mergeElements(String first, String ... others) {
        if (first == null || first.trim().isEmpty()) {
            throw new IllegalArgumentException("You must supply at least one path element.");
        }
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(first);
        if (others != null && others.length > 0) {
            for (String element : others) {
                if (element == null || element.trim().isEmpty()) {
                    throw new IllegalArgumentException("Path element may not be null or empty.");
                }
                elements.add(element);
            }
        }
        return elements;
    }
}

