/*
 * Decompiled with CFR 0.152.
 */
package fm.last.musicbrainz.coverart.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import fm.last.musicbrainz.coverart.CoverArt;
import fm.last.musicbrainz.coverart.CoverArtImage;
import fm.last.musicbrainz.coverart.impl.CoverArtBean;
import fm.last.musicbrainz.coverart.impl.CoverArtImageBean;
import fm.last.musicbrainz.coverart.impl.DefaultCoverArtArchiveClient;
import fm.last.musicbrainz.coverart.impl.IsBackImage;
import fm.last.musicbrainz.coverart.impl.IsFrontImage;
import fm.last.musicbrainz.coverart.impl.IsImageWithId;
import fm.last.musicbrainz.coverart.impl.ProxiedCoverArtImageBeanDecorator;
import java.util.Collection;
import java.util.List;

class CoverArtBeanDecorator
implements CoverArt {
    private final CoverArtBean delegate;
    private final DefaultCoverArtArchiveClient client;
    private final List<CoverArtImage> coverArtImages = Lists.newArrayList();

    public CoverArtBeanDecorator(CoverArtBean delegate, DefaultCoverArtArchiveClient client) {
        this.delegate = delegate;
        this.client = client;
    }

    @Override
    public List<CoverArtImage> getImages() {
        return this.getProxiedCoverArtImages();
    }

    @Override
    public String getMusicBrainzReleaseUrl() {
        return this.delegate.getRelease();
    }

    @Override
    public CoverArtImage getImageById(long id) {
        return this.getImageOrNull(new IsImageWithId(id));
    }

    @Override
    public CoverArtImage getFrontImage() {
        return this.getImageOrNull(IsFrontImage.INSTANCE);
    }

    @Override
    public CoverArtImage getBackImage() {
        return this.getImageOrNull(IsBackImage.INSTANCE);
    }

    private CoverArtImage getImageOrNull(Predicate<CoverArtImage> filter) {
        Collection filtered = Collections2.filter(this.getProxiedCoverArtImages(), filter);
        if (filtered.isEmpty()) {
            return null;
        }
        return (CoverArtImage)filtered.iterator().next();
    }

    private List<CoverArtImage> getProxiedCoverArtImages() {
        if (this.coverArtImages.isEmpty()) {
            for (CoverArtImageBean image : this.delegate.getImages()) {
                this.coverArtImages.add(new ProxiedCoverArtImageBeanDecorator(image, this.client));
            }
        }
        return this.coverArtImages;
    }
}

