/*
 * Decompiled with CFR 0.152.
 */
package fm.last.musicbrainz.coverart.impl;

import fm.last.musicbrainz.coverart.CoverArt;
import fm.last.musicbrainz.coverart.CoverArtArchiveClient;
import fm.last.musicbrainz.coverart.CoverArtException;
import fm.last.musicbrainz.coverart.impl.FetchImageDataResponseHandler;
import fm.last.musicbrainz.coverart.impl.FetchJsonListingResponseHandler;
import fm.last.musicbrainz.coverart.impl.ProxiedCoverArtFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCoverArtArchiveClient
implements CoverArtArchiveClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCoverArtArchiveClient.class);
    private static final String API_DOMAIN = "coverartarchive.org/";
    private static final String API_ROOT = "http://coverartarchive.org/";
    private static final String API_ROOT_HTTPS = "https://coverartarchive.org/";
    private final HttpClient client;
    private final ProxiedCoverArtFactory factory = new ProxiedCoverArtFactory(this);
    private final ResponseHandler<String> fetchJsonListingHandler = FetchJsonListingResponseHandler.INSTANCE;
    private final ResponseHandler<InputStream> fetchImageDataHandler = FetchImageDataResponseHandler.INSTANCE;
    private boolean useHttps;

    public DefaultCoverArtArchiveClient() {
        this(false);
    }

    public DefaultCoverArtArchiveClient(boolean useHttps) {
        this(useHttps, null);
    }

    public DefaultCoverArtArchiveClient(boolean useHttps, HttpClient client) {
        this.client = client == null ? new DefaultHttpClient() : client;
        this.useHttps = useHttps;
    }

    public boolean isUsingHttps() {
        return this.useHttps;
    }

    @Override
    public CoverArt getByMbid(UUID mbid) throws CoverArtException {
        return this.getByMbid(CoverArtArchiveEntity.RELEASE, mbid);
    }

    @Override
    public CoverArt getReleaseGroupByMbid(UUID mbid) throws CoverArtException {
        return this.getByMbid(CoverArtArchiveEntity.RELEASE_GROUP, mbid);
    }

    private CoverArt getByMbid(CoverArtArchiveEntity entity, UUID mbid) {
        log.info("mbid={}", (Object)mbid);
        HttpGet getRequest = this.getJsonGetRequest(entity, mbid);
        CoverArt coverArt = null;
        try {
            String json = (String)this.client.execute((HttpUriRequest)getRequest, this.fetchJsonListingHandler);
            coverArt = this.factory.valueOf(json);
        }
        catch (IOException e) {
            throw new CoverArtException(e);
        }
        return coverArt;
    }

    InputStream getImageData(String location) throws IOException {
        log.info("location={}", (Object)location);
        HttpGet getRequest = this.getJpegGetRequest(location);
        return (InputStream)this.client.execute((HttpUriRequest)getRequest, this.fetchImageDataHandler);
    }

    private HttpGet getJpegGetRequest(String location) {
        HttpGet getRequest = new HttpGet(location);
        getRequest.addHeader("accept", "image/jpeg");
        return getRequest;
    }

    private HttpGet getJsonGetRequest(CoverArtArchiveEntity entity, UUID mbid) {
        String url = this.useHttps ? API_ROOT_HTTPS : API_ROOT;
        url = url + entity.getUrlParam() + mbid;
        HttpGet getRequest = new HttpGet(url);
        getRequest.addHeader("accept", "application/json");
        return getRequest;
    }

    private static enum CoverArtArchiveEntity {
        RELEASE("release/"),
        RELEASE_GROUP("release-group/");

        private String urlParam;

        private CoverArtArchiveEntity(String urlParam) {
            this.urlParam = urlParam;
        }

        public String getUrlParam() {
            return this.urlParam;
        }
    }
}

