/*
 * Decompiled with CFR 0.152.
 */
package fm.last.musicbrainz.coverart.impl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fm.last.musicbrainz.coverart.CoverArtImage;
import fm.last.musicbrainz.coverart.CoverArtType;
import fm.last.musicbrainz.coverart.impl.CoverArtImageBean;
import fm.last.musicbrainz.coverart.impl.CoverArtTypeStringToEnumValue;
import fm.last.musicbrainz.coverart.impl.DefaultCoverArtArchiveClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

class ProxiedCoverArtImageBeanDecorator
implements CoverArtImage {
    private final CoverArtImageBean delegate;
    private final DefaultCoverArtArchiveClient client;

    public ProxiedCoverArtImageBeanDecorator(CoverArtImageBean delegate, DefaultCoverArtArchiveClient client) {
        this.delegate = delegate;
        this.client = client;
    }

    @Override
    public long getId() {
        return this.delegate.getId();
    }

    @Override
    public long getEdit() {
        return this.delegate.getEdit();
    }

    @Override
    public Set<CoverArtType> getTypes() {
        List<String> types = this.delegate.getTypes();
        return Sets.newHashSet((Iterable)Lists.transform(types, (Function)CoverArtTypeStringToEnumValue.INSTANCE));
    }

    @Override
    public InputStream getImage() throws IOException {
        return this.client.getImageData(this.delegate.getImage());
    }

    @Override
    public String getImageUrl() {
        return this.delegate.getImage();
    }

    @Override
    public boolean isFront() {
        return this.delegate.isFront();
    }

    @Override
    public boolean isBack() {
        return this.delegate.isBack();
    }

    @Override
    public String getComment() {
        return this.delegate.getComment();
    }

    @Override
    public boolean isApproved() {
        return this.delegate.isApproved();
    }

    @Override
    public InputStream getLargeThumbnail() throws IOException {
        return this.client.getImageData(this.delegate.getThumbnails().getLarge());
    }

    @Override
    public String getLargeThumbnailUrl() {
        return this.delegate.getThumbnails().getLarge();
    }

    @Override
    public InputStream getSmallThumbnail() throws IOException {
        return this.client.getImageData(this.delegate.getThumbnails().getSmall());
    }

    @Override
    public String getSmallThumbnailUrl() {
        return this.delegate.getThumbnails().getSmall();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProxiedCoverArtImage [id=");
        builder.append(this.getId());
        builder.append(", edit=");
        builder.append(this.getEdit());
        builder.append(", types=");
        builder.append(this.getTypes());
        builder.append(", front=");
        builder.append(this.isFront());
        builder.append(", back=");
        builder.append(this.isBack());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append(", approved=");
        builder.append(this.isApproved());
        builder.append(", image=");
        builder.append(this.delegate.getImage());
        builder.append("]");
        return builder.toString();
    }
}

