/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aggregation.filter;

import etm.core.aggregation.EtmFilter;
import etm.core.monitor.EtmPoint;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexEtmFilter
implements EtmFilter {
    protected final HashSet validNames;
    protected Pattern[] pattern;

    public RegexEtmFilter(String listOfPattern) {
        this(listOfPattern.split(";"));
    }

    public RegexEtmFilter(String[] regexPattern) {
        this.pattern = new Pattern[regexPattern.length];
        for (int i = 0; i < regexPattern.length; ++i) {
            String string = regexPattern[i].trim();
            if (string.length() <= 0) continue;
            this.pattern[i] = Pattern.compile(string);
        }
        this.validNames = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(EtmPoint aPoint) {
        String name = aPoint.getName();
        if (this.validNames.contains(name)) {
            return true;
        }
        for (int i = 0; i < this.pattern.length; ++i) {
            Matcher matcher = this.pattern[i].matcher(name);
            if (!matcher.matches()) continue;
            HashSet hashSet = this.validNames;
            synchronized (hashSet) {
                this.validNames.add(name);
            }
            return true;
        }
        return false;
    }
}

