/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aggregation.log;

import etm.contrib.aggregation.filter.RegexEtmFilter;
import etm.contrib.aggregation.log.DefaultOutputFormatter;
import etm.contrib.aggregation.log.LogOutputFormatter;
import etm.core.aggregation.Aggregator;
import etm.core.aggregation.EtmFilter;
import etm.core.monitor.EtmException;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmPoint;
import etm.core.renderer.MeasurementRenderer;

public abstract class AbstractLogAggregator
implements Aggregator {
    protected static final String DEFAULT_LOG_NAME = "etm-raw-data";
    protected Aggregator delegate;
    protected String logName = "etm-raw-data";
    protected LogOutputFormatter formatter;
    protected EtmFilter filter;
    protected EtmMonitorContext ctx;

    protected AbstractLogAggregator(Aggregator aAggregator) {
        this.delegate = aAggregator;
    }

    public void setLogName(String aLogName) {
        this.logName = aLogName;
    }

    public void setFormatter(LogOutputFormatter aFormatter) {
        this.formatter = aFormatter;
    }

    public void setFormatterClass(Class aFormatterClazz) {
        try {
            this.formatter = (LogOutputFormatter)aFormatterClazz.newInstance();
        }
        catch (Exception e) {
            throw new EtmException((Throwable)e);
        }
    }

    public void setFilterPattern(String matchingPattern) {
        this.filter = new RegexEtmFilter(matchingPattern);
    }

    public void add(EtmPoint point) {
        this.delegate.add(point);
        if (this.filter == null || this.filter.matches(point)) {
            this.logMeasurement(point);
        }
    }

    public void flush() {
        this.delegate.flush();
    }

    public void reset() {
        this.delegate.reset();
    }

    public void reset(String symbolicName) {
        this.delegate.reset(symbolicName);
    }

    public void render(MeasurementRenderer renderer) {
        this.delegate.render(renderer);
    }

    public void init(EtmMonitorContext aCtx) {
        this.ctx = aCtx;
        this.delegate.init(aCtx);
    }

    public void start() {
        if (this.formatter == null) {
            this.formatter = new DefaultOutputFormatter();
        }
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    protected abstract void logMeasurement(EtmPoint var1);
}

