/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aggregation.log;

import etm.contrib.aggregation.log.LogOutputFormatter;
import etm.core.monitor.EtmPoint;
import java.text.NumberFormat;
import java.util.Locale;

public class DefaultOutputFormatter
implements LogOutputFormatter {
    private final NumberFormat numberFormat;

    public DefaultOutputFormatter() {
        this(Locale.getDefault());
    }

    public DefaultOutputFormatter(Locale locale) {
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setMinimumFractionDigits(3);
        this.numberFormat.setMaximumFractionDigits(3);
        this.numberFormat.setGroupingUsed(false);
    }

    public String format(EtmPoint aEtmPoint) {
        String parentName = aEtmPoint.getParent() == null ? "" : this.calculateParentHierarchie(aEtmPoint);
        return "measurementPoint=<" + aEtmPoint.getName() + ">, parent=<" + parentName + ">, transactionTime=<" + this.numberFormat.format(aEtmPoint.getTransactionTime()) + ">, recordingTime=<" + aEtmPoint.getStartTimeMillis() + ">";
    }

    protected String calculateParentHierarchie(EtmPoint aEtmPoint) {
        String hierarchie = "";
        for (EtmPoint parent = aEtmPoint.getParent(); parent != null; parent = parent.getParent()) {
            hierarchie = ";" + parent.getName() + hierarchie;
        }
        return hierarchie.substring(1);
    }
}

