/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aggregation.swing;

import etm.core.aggregation.Aggregate;
import etm.core.aggregation.Aggregator;
import etm.core.aggregation.ExecutionAggregate;
import etm.core.aggregation.RootAggregator;
import etm.core.metadata.AggregatorMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.EtmPoint;
import etm.core.renderer.MeasurementRenderer;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class SimpleTreeModelAggregator
extends DefaultTreeModel
implements Aggregator {
    private static final String DESCRIPTION = "An aggregator which builds up a Swing TreeModel.";
    protected Aggregator delegate;
    static /* synthetic */ Class class$etm$contrib$aggregation$swing$SimpleTreeModelAggregator;

    public SimpleTreeModelAggregator(String aName) {
        this(aName, (Aggregator)new RootAggregator());
    }

    public SimpleTreeModelAggregator(String aName, Aggregator aDelegate) {
        super(new DefaultMutableTreeNode(aName));
        this.delegate = aDelegate;
    }

    public void add(EtmPoint point) {
        LinkedList<String> path = new LinkedList<String>();
        path.add(point.getName());
        for (EtmPoint parent = point.getParent(); parent != null; parent = parent.getParent()) {
            path.addFirst(parent.getName());
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRoot();
        while (path.size() != 0) {
            String currentString = (String)path.removeFirst();
            Enumeration<TreeNode> childs = node.children();
            DefaultMutableTreeNode currentChild = null;
            while (currentChild == null && childs.hasMoreElements()) {
                DefaultMutableTreeNode measurementNode = (DefaultMutableTreeNode)childs.nextElement();
                Aggregate aggregate = (Aggregate)measurementNode.getUserObject();
                if (!aggregate.getName().equals(currentString)) continue;
                currentChild = measurementNode;
            }
            if (currentChild == null) {
                currentChild = new DefaultMutableTreeNode(new ExecutionAggregate(currentString));
                this.insertNodeInto(currentChild, node, this.getChildCount(currentChild));
            }
            node = currentChild;
        }
        ((ExecutionAggregate)node.getUserObject()).addTransaction(point);
        this.nodeChanged(node);
        this.delegate.add(point);
    }

    public void flush() {
        this.delegate.flush();
    }

    public void reset() {
        for (int i = this.getChildCount(this.root) - 1; i >= 0; --i) {
            this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(i));
        }
        this.delegate.reset();
    }

    public void reset(String symbolicName) {
        throw new UnsupportedOperationException();
    }

    public void render(MeasurementRenderer renderer) {
        this.delegate.render(renderer);
    }

    public AggregatorMetaData getMetaData() {
        return new AggregatorMetaData(class$etm$contrib$aggregation$swing$SimpleTreeModelAggregator == null ? (class$etm$contrib$aggregation$swing$SimpleTreeModelAggregator = SimpleTreeModelAggregator.class$("etm.contrib.aggregation.swing.SimpleTreeModelAggregator")) : class$etm$contrib$aggregation$swing$SimpleTreeModelAggregator, DESCRIPTION, false, this.delegate.getMetaData());
    }

    public void init(EtmMonitorContext ctx) {
    }

    public void start() {
    }

    public void stop() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

