/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.aopalliance;

import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class EtmMethodCallInterceptor
implements MethodInterceptor {
    private final EtmMonitor etmMonitor;

    public EtmMethodCallInterceptor(EtmMonitor aEtmMonitor) {
        this.etmMonitor = aEtmMonitor;
    }

    public Object invoke(MethodInvocation aMethodInvocation) throws Throwable {
        EtmPoint etmPoint = this.etmMonitor.createPoint(this.calculateName(aMethodInvocation));
        try {
            Object object = aMethodInvocation.proceed();
            return object;
        }
        catch (Throwable t) {
            this.alterNamePostException(etmPoint, t);
            throw t;
        }
        finally {
            etmPoint.collect();
        }
    }

    protected String calculateName(MethodInvocation aMethodInvocation) {
        Object target = aMethodInvocation.getThis();
        Method method = aMethodInvocation.getMethod();
        return this.calculateShortName(target.getClass()) + "::" + method.getName();
    }

    protected void alterNamePostException(EtmPoint aEtmPoint, Throwable t) {
        aEtmPoint.alterName(aEtmPoint.getName() + " [" + this.calculateShortName(t.getClass()) + "]");
    }

    protected String calculateShortName(Class clazz) {
        String name = clazz.getName();
        int beginIndex = name.lastIndexOf(46);
        if (beginIndex > 0) {
            return name.substring(beginIndex + 1);
        }
        return name;
    }
}

