/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.aspectwerkz;

import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import org.codehaus.aspectwerkz.joinpoint.Signature;
import org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint;

public class EtmAspectWerkzAspect {
    protected final EtmMonitor etmMonitor = EtmManager.getEtmMonitor();

    public Object monitor(StaticJoinPoint joinPoint) throws Throwable {
        EtmPoint etmPoint = this.etmMonitor.createPoint(this.calculateName(joinPoint));
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Throwable t) {
            this.alterNamePostException(etmPoint, t);
            throw t;
        }
        finally {
            etmPoint.collect();
        }
    }

    protected String calculateName(StaticJoinPoint joinPoint) {
        Signature method = joinPoint.getSignature();
        return this.calculateShortName(method.getDeclaringType()) + "::" + method.getName();
    }

    protected void alterNamePostException(EtmPoint aEtmPoint, Throwable t) {
        aEtmPoint.alterName(aEtmPoint.getName() + " [" + this.calculateShortName(t.getClass()) + "]");
    }

    protected String calculateShortName(Class clazz) {
        String name = clazz.getName();
        int beginIndex = name.lastIndexOf(46);
        if (beginIndex > 0) {
            return name.substring(beginIndex + 1);
        }
        return name;
    }
}

