/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.jboss;

import etm.contrib.aop.jboss.JbossInterceptorSupport;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.lang.reflect.Constructor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.Invocation;

public class EtmJbossConstructorInterceptor
extends JbossInterceptorSupport
implements Interceptor {
    protected final EtmMonitor etmMonitor = EtmManager.getEtmMonitor();

    public String getName() {
        return "EtmJbossConstructorInterceptor";
    }

    public Object invoke(Invocation aInvocation) throws Throwable {
        EtmPoint etmPoint = this.etmMonitor.createPoint(this.calculateName((ConstructorInvocation)aInvocation));
        try {
            Object object = aInvocation.invokeNext();
            return object;
        }
        catch (Throwable t) {
            this.alterNamePostException(etmPoint, t);
            throw t;
        }
        finally {
            etmPoint.collect();
        }
    }

    protected String calculateName(ConstructorInvocation aInvocation) {
        Constructor constructor = aInvocation.getConstructor();
        return this.calculateShortName(constructor.getDeclaringClass()) + "::" + constructor.getName();
    }
}

