/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.aop.jboss;

import etm.contrib.aop.jboss.JbossInterceptorSupport;
import etm.core.configuration.EtmManager;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

public class EtmJbossMethodInterceptor
extends JbossInterceptorSupport
implements Interceptor {
    protected final EtmMonitor etmMonitor = EtmManager.getEtmMonitor();

    public String getName() {
        return "EtmJbossMethodInterceptor";
    }

    public Object invoke(Invocation aInvocation) throws Throwable {
        EtmPoint etmPoint = this.etmMonitor.createPoint(this.calculateName((MethodInvocation)aInvocation));
        try {
            Object object = aInvocation.invokeNext();
            return object;
        }
        catch (Throwable t) {
            this.alterNamePostException(etmPoint, t);
            throw t;
        }
        finally {
            etmPoint.collect();
        }
    }

    protected String calculateName(MethodInvocation aInvocation) {
        Method method = aInvocation.getMethod();
        return this.calculateShortName(method.getDeclaringClass()) + "::" + method.getName();
    }
}

