/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console.util;

import etm.core.monitor.EtmException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConsoleUtil {
    public static String appendParameters(String url, Map parameters) {
        return ConsoleUtil.appendParameters(url, parameters, false);
    }

    public static String appendParameters(String url, Map parameters, boolean removeDetails) {
        try {
            if (parameters != null && parameters.size() > 0) {
                url = url.indexOf(63) < 0 ? url + "?" : url + "&amp;";
                Iterator iterator = parameters.keySet().iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    if (removeDetails && "point".equals(name)) continue;
                    url = url + URLEncoder.encode(name, "UTF-8") + "=" + URLEncoder.encode((String)parameters.get(name), "UTF-8") + "&amp;";
                }
                if (url.endsWith("&amp;")) {
                    url = url.substring(0, url.length() - 5);
                }
            }
            return url;
        }
        catch (UnsupportedEncodingException e) {
            throw new EtmException((Throwable)e);
        }
    }

    public static Map extractRequestParameters(byte[] aTemp, int parameterStart, int endOfLine) {
        int index;
        HashMap map = new HashMap();
        int lastEnd = parameterStart;
        int currentDelimiter = parameterStart;
        block4: for (index = parameterStart; index < endOfLine; ++index) {
            switch (aTemp[index]) {
                case 61: {
                    currentDelimiter = index;
                    continue block4;
                }
                case 38: {
                    ConsoleUtil.parseParameters(map, aTemp, index, lastEnd, currentDelimiter);
                    currentDelimiter = index;
                    lastEnd = index;
                }
            }
        }
        ConsoleUtil.parseParameters(map, aTemp, index, lastEnd, currentDelimiter);
        return map;
    }

    private static void parseParameters(Map aMap, byte[] aTemp, int aIndex, int aLastEnd, int aCurrentDelimiter) {
        if (aCurrentDelimiter <= aLastEnd) {
            String key = new String(aTemp, aLastEnd + 1, aIndex - aLastEnd - 1);
            try {
                aMap.put(URLDecoder.decode(key, "UTF-8"), "");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            try {
                String key = new String(aTemp, aLastEnd + 1, aCurrentDelimiter - aLastEnd - 1);
                String value = new String(aTemp, aCurrentDelimiter + 1, aIndex - aCurrentDelimiter - 1).trim();
                aMap.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
    }
}

