/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.renderer;

import etm.core.aggregation.Aggregate;
import etm.core.monitor.EtmException;
import etm.core.renderer.MeasurementRenderer;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class SimpleHtmlRenderer
implements MeasurementRenderer {
    private static final String HEAD = "<table>\n <tr>\n  <th>Measurement Point</th>\n  <th>#</th>\n  <th>Average</th>\n  <th>Min</th>\n  <th>Max</th>\n  <th>Total</th>\n </tr>\n";
    private static final String FOOTER = " <tr><td class=\"footer\" colspan=\"6\">All times in miliseconds. Measurements provided by <a href=\"http://jetm.void.fm\" target=\"_default\">JETM</a></td></tr>\n</table>";
    private static final String NO_RESULTS = " <tr><td colspan=\"6\">No measurement results available.</td></tr>\n";
    private NumberFormat timeFormatter;
    private NumberFormat numberFormatter;
    private Writer writer;

    public SimpleHtmlRenderer(Writer aWriter) {
        this(aWriter, Locale.getDefault());
    }

    public SimpleHtmlRenderer(Writer aWriter, Locale aLocale) {
        this.writer = aWriter;
        this.timeFormatter = NumberFormat.getNumberInstance(aLocale);
        this.timeFormatter.setMaximumFractionDigits(3);
        this.timeFormatter.setMinimumFractionDigits(3);
        this.timeFormatter.setGroupingUsed(true);
        this.numberFormatter = NumberFormat.getNumberInstance(aLocale);
        this.numberFormatter.setMaximumFractionDigits(0);
        this.numberFormatter.setMinimumFractionDigits(0);
        this.numberFormatter.setGroupingUsed(true);
    }

    public void render(Map points) {
        try {
            this.writer.write(HEAD.toCharArray());
            if (points.size() == 0) {
                this.writer.write(NO_RESULTS.toCharArray());
            } else {
                StringBuffer buffer = new StringBuffer();
                TreeMap map = new TreeMap(points);
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    Aggregate point = (Aggregate)iterator.next();
                    buffer.append(" <tr>\n");
                    buffer.append("  <td>");
                    this.writeNames(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td>");
                    this.writeMeasurements(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td>");
                    this.writeAverage(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td>");
                    this.writeMin(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td>");
                    this.writeMax(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append("  <td>");
                    this.writeTotals(buffer, point, 0);
                    buffer.append("</td>\n");
                    buffer.append(" </tr>\n");
                }
                this.writer.write(buffer.toString().toCharArray());
            }
            this.writer.write(FOOTER.toCharArray());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new EtmException("Unable to write to writer: " + e);
        }
    }

    private void writeNames(StringBuffer aBuffer, Aggregate aPoint, int depth) {
        if (depth > 0) {
            aBuffer.append("<div class=\"childname\" >");
        } else {
            aBuffer.append("<div class=\"parentname\" >");
        }
        aBuffer.append(aPoint.getName());
        if (aPoint.hasChilds()) {
            int currentDepth = depth + 1;
            Map childs = aPoint.getChilds();
            Iterator iterator = childs.values().iterator();
            while (iterator.hasNext()) {
                Aggregate child = (Aggregate)iterator.next();
                this.writeNames(aBuffer, child, currentDepth);
            }
        }
        aBuffer.append("</div>");
    }

    private void writeTotals(StringBuffer aBuffer, Aggregate aPoint, int depth) {
        if (depth > 0) {
            aBuffer.append("<div class=\"childtotal\" >");
        } else {
            aBuffer.append("<div class=\"parenttotal\" >");
        }
        aBuffer.append(this.timeFormatter.format(aPoint.getTotal()));
        if (aPoint.hasChilds()) {
            Map childs = aPoint.getChilds();
            int currentDepth = depth + 1;
            Iterator iterator = childs.values().iterator();
            while (iterator.hasNext()) {
                Aggregate child = (Aggregate)iterator.next();
                this.writeTotals(aBuffer, child, currentDepth);
            }
        }
        aBuffer.append("</div>");
    }

    private void writeAverage(StringBuffer aBuffer, Aggregate aPoint, int depth) {
        if (depth > 0) {
            aBuffer.append("<div class=\"childtime\" >");
        } else {
            aBuffer.append("<div class=\"parenttime\" >");
        }
        aBuffer.append(this.timeFormatter.format(aPoint.getAverage()));
        if (aPoint.hasChilds()) {
            Map childs = aPoint.getChilds();
            int currentDepth = depth + 1;
            Iterator iterator = childs.values().iterator();
            while (iterator.hasNext()) {
                Aggregate child = (Aggregate)iterator.next();
                this.writeAverage(aBuffer, child, currentDepth + 1);
            }
        }
        aBuffer.append("</div>");
    }

    private void writeMin(StringBuffer aBuffer, Aggregate aPoint, int depth) {
        if (depth > 0) {
            aBuffer.append("<div class=\"childtime\" >");
        } else {
            aBuffer.append("<div class=\"parenttime\" >");
        }
        aBuffer.append(this.timeFormatter.format(aPoint.getMin()));
        if (aPoint.hasChilds()) {
            Map childs = aPoint.getChilds();
            int currentDepth = depth + 1;
            Iterator iterator = childs.values().iterator();
            while (iterator.hasNext()) {
                Aggregate child = (Aggregate)iterator.next();
                this.writeMin(aBuffer, child, currentDepth + 1);
            }
        }
        aBuffer.append("</div>");
    }

    private void writeMax(StringBuffer aBuffer, Aggregate aPoint, int depth) {
        if (depth > 0) {
            aBuffer.append("<div class=\"childtime\" >");
        } else {
            aBuffer.append("<div class=\"parenttime\" >");
        }
        aBuffer.append(this.timeFormatter.format(aPoint.getMax()));
        if (aPoint.hasChilds()) {
            Map childs = aPoint.getChilds();
            int currentDepth = depth + 1;
            Iterator iterator = childs.values().iterator();
            while (iterator.hasNext()) {
                Aggregate child = (Aggregate)iterator.next();
                this.writeMax(aBuffer, child, currentDepth + 1);
            }
        }
        aBuffer.append("</div>");
    }

    private void writeMeasurements(StringBuffer aBuffer, Aggregate aPoint, int depth) {
        if (depth > 0) {
            aBuffer.append("<div class=\"childmeasurement\" >");
        } else {
            aBuffer.append("<div class=\"parentmeasurement\" >");
        }
        aBuffer.append(this.numberFormatter.format(aPoint.getMeasurements()));
        if (aPoint.hasChilds()) {
            Map childs = aPoint.getChilds();
            int currentDepth = depth + 1;
            Iterator iterator = childs.values().iterator();
            while (iterator.hasNext()) {
                Aggregate child = (Aggregate)iterator.next();
                this.writeMeasurements(aBuffer, child, currentDepth);
            }
        }
        aBuffer.append("</div>");
    }
}

