/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.renderer.plugin;

import etm.core.aggregation.Aggregate;
import etm.core.metadata.EtmMonitorMetaData;
import etm.core.metadata.PluginMetaData;
import etm.core.monitor.EtmMonitorContext;
import etm.core.monitor.event.AggregationListener;
import etm.core.monitor.event.MonitorResetEvent;
import etm.core.monitor.event.PreMonitorResetEvent;
import etm.core.monitor.event.PreRootResetEvent;
import etm.core.monitor.event.RootCreateEvent;
import etm.core.monitor.event.RootResetEvent;
import etm.core.plugin.EtmPlugin;
import etm.core.renderer.SimpleTextRenderer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;

public abstract class DumpOnShutDownPlugin
implements EtmPlugin,
AggregationListener {
    private static final String DEFAULT_LOG_NAME = "etm-dump";
    protected String logName = "etm-dump";
    protected EtmMonitorContext ctx;
    protected String lineSeparator = System.getProperty("line.separator");
    private String description;

    protected DumpOnShutDownPlugin(String aDescription) {
        this.description = aDescription;
    }

    public void setLogName(String aLogName) {
        this.logName = aLogName;
    }

    public void init(EtmMonitorContext aCtx) {
        this.ctx = aCtx;
    }

    public PluginMetaData getPluginMetaData() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("logName", this.logName);
        return new PluginMetaData(this.getClass(), this.description, properties);
    }

    public void onRootCreate(RootCreateEvent event) {
    }

    public void preRootReset(PreRootResetEvent event) {
        StringWriter writer = new StringWriter();
        EtmMonitorMetaData etmMonitorMetaData = this.ctx.getEtmMonitor().getMetaData();
        Aggregate aggregate = event.getAggregate();
        writer.write("Dumping performance results '");
        writer.write(aggregate.getName());
        writer.write("' for period ");
        writer.write(etmMonitorMetaData.getLastResetTime().toString());
        writer.write(" - ");
        writer.write(new Date().toString());
        writer.write(this.lineSeparator);
        SimpleTextRenderer textRenderer = new SimpleTextRenderer((Writer)writer);
        HashMap<String, Aggregate> map = new HashMap<String, Aggregate>();
        map.put(aggregate.getName(), aggregate);
        textRenderer.render(map);
        this.logResetDetail(writer.toString());
    }

    public void onRootReset(RootResetEvent event) {
    }

    public void preStateReset(PreMonitorResetEvent event) {
        StringWriter writer = new StringWriter();
        EtmMonitorMetaData etmMonitorMetaData = this.ctx.getEtmMonitor().getMetaData();
        writer.write("Dumping performance results for period ");
        writer.write(etmMonitorMetaData.getLastResetTime().toString());
        writer.write(" - ");
        writer.write(new Date().toString());
        writer.write(this.lineSeparator);
        SimpleTextRenderer textRenderer = new SimpleTextRenderer((Writer)writer);
        textRenderer.render(event.getAggregates());
        this.logResetDetail(writer.toString());
    }

    public void onStateReset(MonitorResetEvent event) {
    }

    protected abstract void logResetDetail(String var1);
}

