/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.renderer.swing;

import etm.core.aggregation.Aggregate;
import etm.core.renderer.MeasurementRenderer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class SimpleTreeModelRenderer
extends DefaultTreeModel
implements MeasurementRenderer {
    public SimpleTreeModelRenderer(String aRootName) {
        super(new DefaultMutableTreeNode(aRootName));
    }

    public void render(Map points) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRoot();
        this.renderNested(node, points);
    }

    private void renderNested(DefaultMutableTreeNode parent, Map map) {
        TreeMap workingCopy = new TreeMap(map);
        ArrayList<DefaultMutableTreeNode> toBeRemoved = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> childs = parent.children();
        while (childs.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)childs.nextElement();
            ExecutionPointWrapper currentAggregate = (ExecutionPointWrapper)currentNode.getUserObject();
            Aggregate newAggregate = (Aggregate)workingCopy.get(currentAggregate.getName());
            if (newAggregate == null) {
                toBeRemoved.add(currentNode);
                continue;
            }
            workingCopy.remove(currentAggregate.getName());
            currentAggregate.setAggregate(newAggregate);
            if (newAggregate.hasChilds()) {
                this.renderNested(currentNode, newAggregate.getChilds());
            }
            this.nodeChanged(currentNode);
        }
        for (int i = 0; i < toBeRemoved.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)toBeRemoved.get(i);
            this.removeNodeFromParent(defaultMutableTreeNode);
        }
        Iterator iterator = workingCopy.keySet().iterator();
        while (iterator.hasNext()) {
            Aggregate aggregate = (Aggregate)workingCopy.get(iterator.next());
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(new ExecutionPointWrapper(aggregate));
            this.insertNodeInto(newChild, parent, parent.getChildCount());
            if (!aggregate.hasChilds()) continue;
            this.renderNested(newChild, aggregate.getChilds());
        }
    }

    class ExecutionPointWrapper {
        private Aggregate aggregate;

        public ExecutionPointWrapper(Aggregate aAggregate) {
            this.aggregate = aAggregate;
        }

        public void setAggregate(Aggregate aAggregate) {
            this.aggregate = aAggregate;
        }

        public String toString() {
            return this.aggregate.toString();
        }

        public String getName() {
            return this.aggregate.getName();
        }
    }
}

