/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.core;

import etm.contrib.rrd.core.RrdExecutionWriter;
import etm.core.monitor.EtmPoint;

public abstract class AbstractRrdExecutionWriter
implements RrdExecutionWriter {
    protected long startInterval;
    protected long endInterval;
    protected long increment;
    protected int transactions;
    protected double min;
    protected double max;
    protected double total;

    protected AbstractRrdExecutionWriter(long aStartInterval, long aIncrement) {
        this.startInterval = aStartInterval;
        this.increment = aIncrement;
        this.endInterval = this.startInterval + this.increment;
        this.initAggregation();
    }

    public void onNextMeasurement(EtmPoint measurement) {
        long l = this.calculateTimestamp(measurement);
        if (l > this.endInterval) {
            if (this.startInterval == 0L || l > this.endInterval + this.increment) {
                this.startInterval = l;
                this.endInterval = this.startInterval + this.increment;
            } else {
                this.flushStatus();
                this.startInterval = this.endInterval;
                this.endInterval = this.startInterval + this.increment;
            }
            this.initAggregation();
        }
        if (l >= this.startInterval) {
            ++this.transactions;
            double transactionTime = measurement.getTransactionTime();
            this.min = transactionTime < this.min ? transactionTime : this.min;
            this.max = transactionTime > this.max ? transactionTime : this.max;
            this.total += transactionTime;
        }
    }

    protected void initAggregation() {
        this.transactions = 0;
        this.total = 0.0;
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
    }

    protected abstract long calculateTimestamp(EtmPoint var1);

    protected abstract void flushStatus();
}

