/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.contrib.rrd.core.OfflineLogParser;
import etm.contrib.rrd.rrd4j.Rrd4jDestination;
import etm.contrib.rrd.rrd4j.Rrd4jUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.rrd4j.core.Util;

public class Rrd4jMain {
    private static final String DATE_FORMAT = "yyyy.MM.dd";

    public static void main(String[] args) {
        Rrd4jUtilCommand command;
        if (args.length < 3) {
            Rrd4jMain.printUsage("Missing command line parameters.");
            System.exit(-1);
        }
        if ("create-graph".equalsIgnoreCase((command = new Rrd4jUtilCommand(args)).getCommand())) {
            long intervalStart;
            long intervalEnd;
            Rrd4jUtil util = new Rrd4jUtil();
            URL url = util.locateTemplate(command.getTemplate());
            File destination = new File(command.getDestination());
            if (command.getOffset() != null) {
                if (command.getOffset().endsWith("!")) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    String offset = command.getOffset();
                    offset = offset.substring(0, offset.length() - 1);
                    intervalEnd = Util.getTimestamp((Date)calendar.getTime()) - Rrd4jMain.calculate(offset);
                } else {
                    intervalEnd = Util.getTimestamp() - Rrd4jMain.calculate(command.getOffset());
                }
                intervalStart = intervalEnd - Rrd4jMain.calculate(command.getInterval());
            } else if (command.getBeginDate() != null) {
                String beginDate = command.getBeginDate();
                intervalStart = Util.getTimestamp((Date)Rrd4jMain.getCalendar(beginDate).getTime());
                if (command.getEndDate() != null) {
                    String endDate = command.getEndDate();
                    intervalEnd = Util.getTimestamp((Date)Rrd4jMain.getCalendar(endDate).getTime());
                } else {
                    intervalEnd = command.getInterval() != null ? intervalStart + Rrd4jMain.calculate(command.getInterval()) : Util.getTimestamp();
                }
            } else {
                intervalEnd = Util.getTimestamp();
                intervalStart = intervalEnd - Rrd4jMain.calculate(command.getInterval());
            }
            if (command.getSource() != null) {
                File source = new File(command.getSource());
                util.createGraph(url, source, destination, intervalStart, intervalEnd, command.getProperties());
            } else {
                util.createGraph(url, destination, intervalStart, intervalEnd, command.getProperties());
            }
        } else if ("create-db".equalsIgnoreCase(command.getCommand())) {
            Rrd4jUtil util = new Rrd4jUtil();
            URL url = util.locateTemplate(command.getTemplate());
            File destination = new File(command.getDestination());
            util.createRrdDb(url, destination, command.getProperties());
        } else if ("import".equalsIgnoreCase(command.getCommand())) {
            OfflineLogParser parser = new OfflineLogParser();
            if (command.getFilter() != null) {
                parser.setPattern(command.getFilter());
            }
            String destinations = command.getDestination();
            StringTokenizer tk = new StringTokenizer(destinations, ";");
            while (tk.hasMoreTokens()) {
                String s = tk.nextToken();
                int index = s.indexOf(33);
                String filename = s.substring(0, index);
                String pattern = s.substring(index + 1);
                parser.register(new Rrd4jDestination(pattern, new File(filename)));
            }
            try {
                parser.parse(new File(command.getSource()));
            }
            catch (IOException e) {
                System.err.print("Error importing from '" + command.getSource() + ": ");
                e.printStackTrace();
                System.exit(-1);
            }
        } else {
            Rrd4jMain.printUsage("Unsupported command line parameters.");
            System.exit(-1);
        }
    }

    private static void printUsage(String s) {
        System.out.print(s);
        System.out.println(" Usage: ");
        System.out.println("rrd4j-tool create-db -t template -d destination -p key1=value1,key2=value2,key3=value3");
        System.out.println("rrd4j-tool create-graph -t template -d destination -i interval -o offset -p key1=value1,key2=value2,key3=value3");
        System.out.println("rrd4j-tool import -s sourcefile -d destinationDb -f pattern");
    }

    private static long calculate(String aTimeframe) {
        if (aTimeframe == null || aTimeframe.length() < 2) {
            return 3600L;
        }
        int value = Integer.parseInt(aTimeframe.substring(0, aTimeframe.length() - 1));
        switch (aTimeframe.charAt(aTimeframe.length() - 1)) {
            case 'h': {
                return value * 60 * 60;
            }
            case 'd': {
                return value * 60 * 60 * 24;
            }
            case 'm': {
                return value * 60 * 60 * 24 * 30;
            }
            case 'y': {
                return value * 60 * 60 * 24 * 365;
            }
        }
        return 3600L;
    }

    private static Calendar getCalendar(String aDate) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(new SimpleDateFormat(DATE_FORMAT).parse(aDate));
        }
        catch (ParseException e) {
            System.err.print("Error parsing date '" + aDate + "' using date format " + DATE_FORMAT + ": ");
            e.printStackTrace();
            System.exit(-1);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    static class Rrd4jUtilCommand {
        private String command;
        private String template;
        private String destination;
        private String beginDate;
        private String endDate;
        private String interval;
        private String offset;
        private String source;
        private String filter;
        private Map properties;

        public Rrd4jUtilCommand(String[] args) {
            this.command = args[0];
            block11: for (int i = 1; i < args.length; ++i) {
                String current = args[i];
                if (current.length() <= 1 || !current.startsWith("-") || args.length <= i + 1) continue;
                ++i;
                switch (current.charAt(1)) {
                    case 't': {
                        this.template = args[i];
                        continue block11;
                    }
                    case 'd': {
                        this.destination = args[i];
                        continue block11;
                    }
                    case 'i': {
                        this.interval = args[i];
                        continue block11;
                    }
                    case 'o': {
                        this.offset = args[i];
                        continue block11;
                    }
                    case 's': {
                        this.source = args[i];
                        continue block11;
                    }
                    case 'f': {
                        this.filter = args[i];
                        continue block11;
                    }
                    case 'b': {
                        this.beginDate = args[i];
                        continue block11;
                    }
                    case 'e': {
                        this.endDate = args[i];
                        continue block11;
                    }
                    case 'p': {
                        this.properties = new HashMap();
                        StringTokenizer tk = new StringTokenizer(args[i], ",");
                        while (tk.hasMoreTokens()) {
                            String s = tk.nextToken();
                            int index = s.indexOf("=");
                            this.properties.put(s.substring(0, index), s.substring(index + 1));
                        }
                        continue block11;
                    }
                }
            }
        }

        public String getSource() {
            return this.source;
        }

        public String getCommand() {
            return this.command;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getInterval() {
            return this.interval;
        }

        public Map getProperties() {
            return this.properties;
        }

        public String getOffset() {
            return this.offset;
        }

        public String getFilter() {
            return this.filter;
        }

        public String getBeginDate() {
            return this.beginDate;
        }

        public String getEndDate() {
            return this.endDate;
        }
    }
}

