/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.util;

import etm.core.aggregation.Aggregate;
import java.util.Comparator;

public class ExecutionAggregateComparator
implements Comparator {
    public static final int TYPE_NAME = 1;
    public static final int TYPE_EXCECUTIONS = 2;
    public static final int TYPE_AVERAGE = 3;
    public static final int TYPE_MIN = 4;
    public static final int TYPE_MAX = 5;
    public static final int TYPE_TOTAL = 6;
    private int type;
    private boolean descending;

    public ExecutionAggregateComparator() {
        this(1, false);
    }

    public ExecutionAggregateComparator(int aType) {
        this(aType, true);
    }

    public ExecutionAggregateComparator(int aType, boolean descendingOrder) {
        this.type = aType;
        this.descending = descendingOrder;
    }

    public int compare(Object o1, Object o2) {
        Aggregate one = (Aggregate)o1;
        Aggregate two = (Aggregate)o2;
        switch (this.type) {
            case 1: {
                return this.compareName(one, two);
            }
            case 2: {
                return this.compareExecutions(one, two);
            }
            case 3: {
                return this.compareAverage(one, two);
            }
            case 4: {
                return this.compareMin(one, two);
            }
            case 5: {
                return this.compareMax(one, two);
            }
            case 6: {
                return this.compareTotal(one, two);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + this.type);
    }

    protected int compareName(Aggregate one, Aggregate two) {
        int value = one.getName().compareTo(two.getName());
        return this.descending ? value : -1 * value;
    }

    protected int compareExecutions(Aggregate one, Aggregate two) {
        if (one.getMeasurements() < two.getMeasurements()) {
            return this.descending ? 1 : -1;
        }
        if (two.getMeasurements() < one.getMeasurements()) {
            return this.descending ? -1 : 1;
        }
        return 0;
    }

    protected int compareAverage(Aggregate one, Aggregate two) {
        if (one.getAverage() < two.getAverage()) {
            return this.descending ? 1 : -1;
        }
        if (two.getAverage() < one.getAverage()) {
            return this.descending ? -1 : 1;
        }
        return 0;
    }

    protected int compareMin(Aggregate one, Aggregate two) {
        if (one.getMin() < two.getMin()) {
            return this.descending ? 1 : -1;
        }
        if (two.getMin() < one.getMin()) {
            return this.descending ? -1 : 1;
        }
        return 0;
    }

    protected int compareMax(Aggregate one, Aggregate two) {
        if (one.getMax() < two.getMax()) {
            return this.descending ? 1 : -1;
        }
        if (two.getMax() < one.getMax()) {
            return this.descending ? -1 : 1;
        }
        return 0;
    }

    protected int compareTotal(Aggregate one, Aggregate two) {
        if (one.getTotal() < two.getTotal()) {
            return this.descending ? 1 : -1;
        }
        if (two.getTotal() < one.getTotal()) {
            return this.descending ? -1 : 1;
        }
        return 0;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDescending() {
        return this.descending;
    }
}

