package fo.nya.leaderboard;


/**
 * Created by 0da on 08.06.2023 20:45; (ﾉ◕ヮ◕)ﾉ*:･ﾟ✧
 * <br>
 * Immutable state of on entry in leaderboard.
 *
 * @param place  place of entry in a leaderboard. Always equals or grater than 1.
 * @param target target of that entry.
 * @param score  current score for entry.
 */
public record LeaderboardRow(int place, long target, long score) {

    public LeaderboardRow {
        if (place <= 0) throw new IllegalArgumentException("Minimal value for place is 1. Actual: " + place);
    }
}
