/*
 * Decompiled with CFR 0.152.
 */
package fo.nya.leaderboard;

import fo.nya.leaderboard.LeaderboardRow;
import fo.nya.leaderboard.implementation.SkipListLeaderboard;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface Leaderboard {
    public int size();

    public List<LeaderboardRow> slice(int var1, int var2, boolean var3);

    default public List<LeaderboardRow> slice(int from, int limit) {
        return this.slice(from, limit, false);
    }

    public Optional<LeaderboardRow> find(long var1);

    public List<LeaderboardRow> around(long var1, int var3, int var4, boolean var5);

    public void update(long var1, long var3);

    default public void updateAll(Map<Long, Long> entries) {
        for (Map.Entry<Long, Long> entry : entries.entrySet()) {
            this.update(entry.getKey(), entry.getValue());
        }
    }

    public void remove(long var1);

    public static Leaderboard create() {
        return new SkipListLeaderboard();
    }
}

