/*
 * Decompiled with CFR 0.152.
 */
package fo.nya.leaderboard.implementation;

import fo.nya.leaderboard.Leaderboard;
import fo.nya.leaderboard.LeaderboardRow;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ArrayLeaderboard
implements Leaderboard {
    private static final int ENTRY_SIZE = 2;
    private static final int TARGET_OFFSET = 0;
    private static final int SCORE_OFFSET = 1;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final HashMap<Long, Long> scores = new HashMap();
    long[] data = new long[3];
    private int size = 0;

    ArrayLeaderboard() {
    }

    @Override
    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LeaderboardRow> slice(int from, int limit, boolean desc) {
        LinkedList<LeaderboardRow> result = new LinkedList<LeaderboardRow>();
        ReentrantReadWriteLock.ReadLock lock = this.lock.readLock();
        lock.lock();
        try {
            int f = Math.max(from - 1, 0);
            int dir = desc ? -1 : 1;
            int i = 0;
            while (Math.abs(i) < limit && f + i < this.size && f + i >= 0) {
                int place = f + i;
                result.add(new LeaderboardRow(place + 1, this.data[place * 2 + 0], this.data[place * 2 + 1]));
                i += dir;
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<LeaderboardRow> find(long target) {
        ReentrantReadWriteLock.ReadLock lock = this.lock.readLock();
        lock.lock();
        try {
            int place = this.get(target);
            if (place == -1) {
                Optional<LeaderboardRow> optional = Optional.empty();
                return optional;
            }
            Optional<LeaderboardRow> optional = Optional.of(new LeaderboardRow(place + 1, target, this.data[place * 2 + 1]));
            return optional;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(long target, long score) {
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        lock.lock();
        try {
            int place = this.get(target);
            if (place < 0) {
                place = this.insert(target, score);
            }
            this.scores.put(target, score);
            this.data[place * 2 + 1] = score;
            int pointer = place;
            while (true) {
                if (pointer > 0 && this.data[pointer * 2 + 1] > this.data[(pointer - 1) * 2 + 1]) {
                    this.swap(pointer * 2 + 0, (pointer - 1) * 2 + 0);
                    this.swap(pointer * 2 + 1, (pointer - 1) * 2 + 1);
                    --pointer;
                    continue;
                }
                if (pointer < this.size - 1 && this.data[pointer * 2 + 1] <= this.data[(pointer + 1) * 2 + 1]) {
                    this.swap(pointer * 2 + 0, (pointer + 1) * 2 + 0);
                    this.swap(pointer * 2 + 1, (pointer + 1) * 2 + 1);
                    ++pointer;
                    continue;
                }
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void remove(long target) {
        throw new AbstractMethodError();
    }

    @Override
    public List<LeaderboardRow> around(long target, int up, int down, boolean desc) {
        throw new AbstractMethodError();
    }

    public int get(long key) {
        Long score = this.scores.get(key);
        if (score == null) {
            return -1;
        }
        int place = this.findScorePlace(score);
        while (this.data[--place * 2 + 0] != key) {
        }
        return place;
    }

    private int insert(long target, long score) {
        int place = this.findScorePlace(score);
        this.resize();
        System.arraycopy(this.data, place * 2, this.data, place * 2 + 2, this.data.length - place * 2 - 2);
        this.data[place * 2 + 0] = target;
        ++this.size;
        return place;
    }

    private void resize() {
        int required = this.size * 2 + 2 - this.data.length;
        if (required > 0) {
            if (this.data.length == 0x7FFFFFF7) {
                throw new IllegalStateException("This leaderboard is already contains maximum amount of entries");
            }
            int newSize = Math.max(required, this.data.length) + this.data.length;
            this.data = Arrays.copyOf(this.data, Math.min(newSize, 0x7FFFFFF7));
        }
    }

    private int findScorePlace(long score) {
        double s = (double)score - 0.5;
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.data[mid * 2 + 1];
            if ((double)midVal < s) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    private void swap(int a, int b) {
        long tmp = this.data[a];
        this.data[a] = this.data[b];
        this.data[b] = tmp;
    }
}

