/*
 * Decompiled with CFR 0.152.
 */
package fo.nya.leaderboard.implementation;

import fo.nya.leaderboard.Leaderboard;
import fo.nya.leaderboard.LeaderboardRow;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;

public class SkipListLeaderboard
implements Leaderboard {
    private final AtomicLong order = new AtomicLong();
    private final ConcurrentHashMap<Long, Entry> lookup = new ConcurrentHashMap();
    private final ConcurrentSkipListSet<Entry> data = new ConcurrentSkipListSet();

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public List<LeaderboardRow> slice(int from, int limit, boolean desc) {
        LinkedList<LeaderboardRow> results = new LinkedList<LeaderboardRow>();
        int f = from = Math.max(from - 1, 0);
        if (limit == 0 || f > this.size() || this.size() == 0) {
            return results;
        }
        Entry target = null;
        for (Entry next : this.data) {
            if (f <= 0) {
                target = next;
                break;
            }
            --f;
        }
        if (target == null) {
            return results;
        }
        int p = from + 1;
        int dir = desc ? -1 : 1;
        for (Entry entry : desc ? this.data.headSet(target, true).descendingSet() : this.data.tailSet(target, true)) {
            if (limit-- <= 0) break;
            results.add(new LeaderboardRow(p, entry.target(), entry.score()));
            p += dir;
        }
        return results;
    }

    @Override
    public List<LeaderboardRow> around(long target, int up, int down, boolean desc) {
        NavigableSet<Entry> lower;
        NavigableSet<Entry> upper;
        LeaderboardRow row = this.find(target).orElse(null);
        Entry entry = this.lookup.get(target);
        LinkedList<LeaderboardRow> result = new LinkedList<LeaderboardRow>();
        if (row == null || entry == null) {
            return result;
        }
        result.add(row);
        if (desc) {
            upper = this.data.tailSet(entry, false);
            lower = this.data.headSet(entry, false).descendingSet();
        } else {
            upper = this.data.headSet(entry, false).descendingSet();
            lower = this.data.tailSet(entry, false);
        }
        int dir = desc ? 1 : -1;
        int u = 0;
        for (Entry e : upper) {
            if (u >= up) break;
            result.addFirst(new LeaderboardRow(row.place() + ++u * dir, e.target(), e.score()));
        }
        int d = 0;
        for (Entry e : lower) {
            if (d >= down) break;
            result.addLast(new LeaderboardRow(row.place() - ++d * dir, e.target(), e.score()));
        }
        return result;
    }

    @Override
    public Optional<LeaderboardRow> find(long target) {
        return Optional.ofNullable(this.lookup.get(target)).map(e -> new LeaderboardRow(this.data.headSet(e).size() + 1, e.target(), e.score()));
    }

    @Override
    public void update(long target, long score) {
        this.lookup.compute(target, (__, e) -> {
            if (e != null) {
                this.data.remove(e);
            }
            e = new Entry(target, score, this.order.incrementAndGet());
            this.data.add((Entry)e);
            return e;
        });
    }

    @Override
    public void remove(long target) {
        this.lookup.compute(target, (__, e) -> {
            if (e != null) {
                this.data.remove(e);
            }
            return null;
        });
    }

    private record Entry(long target, long score, long order) implements Comparable<Entry>
    {
        public static final Comparator<Entry> COMPARATOR = Comparator.comparingLong(Entry::score).reversed().thenComparing(Entry::order);

        @Override
        public int compareTo(Entry o) {
            return COMPARATOR.compare(this, o);
        }
    }
}

