/*
 * Decompiled with CFR 0.152.
 */
package foundation.algorand.xhdwalletapi;

import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"encodeAddress", "", "bytes", "", "XHDWalletAPI-Android_release"})
public final class UtilsKt {
    @NotNull
    public static final String encodeAddress(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int lenBytes = 32;
        int checksumLenBytes = 4;
        int expectedStrEncodedLen = 58;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512/256");
        byte[] fullHash = messageDigest.digest(bytes);
        byte[] hashedAddr = Arrays.copyOf(fullHash, lenBytes);
        Intrinsics.checkNotNull((Object)hashedAddr);
        byte[] checksum = ArraysKt.sliceArray((byte[])hashedAddr, (IntRange)RangesKt.until((int)(hashedAddr.length - checksumLenBytes), (int)hashedAddr.length));
        byte[] checksumAddr = ArraysKt.plus((byte[])bytes, (byte[])checksum);
        String string = new Base32().encodeAsString(checksumAddr);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeAsString(...)");
        char[] cArray = new char[]{'='};
        String res = StringsKt.trimEnd((String)string, (char[])cArray);
        if (res.length() != expectedStrEncodedLen) {
            throw new Exception("unexpected address length " + res.length());
        }
        return res;
    }
}

