/*
 * Decompiled with CFR 0.152.
 */
package foundation.algorand.xhdwalletapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.goterl.lazysodium.LazySodium;
import foundation.algorand.xhdwalletapi.BigIntegerOverflowException;
import foundation.algorand.xhdwalletapi.Bip32DerivationType;
import foundation.algorand.xhdwalletapi.DataValidationException;
import foundation.algorand.xhdwalletapi.Encoding;
import foundation.algorand.xhdwalletapi.KeyContext;
import foundation.algorand.xhdwalletapi.SignMetadata;
import foundation.algorand.xhdwalletapi.XHDWalletAPIBaseKt;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.pwall.json.schema.JSONSchema;
import org.jetbrains.annotations.NotNull;
import org.msgpack.jackson.dataformat.MessagePackFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u0000 G2\u00020\u0001:\u0001GB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J*\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ*\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001bJ>\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\rH\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$J.\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u0010)\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J6\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,J:\u0010-\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b.\u0010/J&\u00100\u001a\u00020\u00032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0(2\u0006\u00101\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u000e\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204J\u000e\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003JB\u00105\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u00106\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b7\u00108JJ\u00109\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u00101\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0000\u00a2\u0006\u0004\b<\u0010=J\u001d\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0002\bBJ\u001e\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020\u00032\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006H"}, d2={"Lfoundation/algorand/xhdwalletapi/XHDWalletAPIBase;", "", "seed", "", "([B)V", "lazySodium", "Lcom/goterl/lazysodium/LazySodium;", "getLazySodium", "()Lcom/goterl/lazysodium/LazySodium;", "ECDH", "context", "Lfoundation/algorand/xhdwalletapi/KeyContext;", "account", "Lkotlin/UInt;", "change", "keyIndex", "otherPartyPub", "meFirst", "", "derivationType", "Lfoundation/algorand/xhdwalletapi/Bip32DerivationType;", "ECDH-fSESelo", "(Lfoundation/algorand/xhdwalletapi/KeyContext;III[BZLfoundation/algorand/xhdwalletapi/Bip32DerivationType;)[B", "deriveChildNodePrivate", "extendedKey", "index", "deriveChildNodePrivate-OsBMiQA", "([BILfoundation/algorand/xhdwalletapi/Bip32DerivationType;)[B", "deriveChildNodePublic", "deriveChildNodePublic-OsBMiQA", "deriveHardened", "Lkotlin/Pair;", "kl", "kr", "cc", "deriveHardened-hJeF8fQ$XHDWalletAPI_Android_release", "([B[B[BI)Lkotlin/Pair;", "deriveKey", "rootKey", "bip44Path", "", "isPrivate", "deriveNonHardened", "deriveNonHardened-jXDDuk8", "([B[BI)Lkotlin/Pair;", "keyGen", "keyGen-G2O0Dqo", "(Lfoundation/algorand/xhdwalletapi/KeyContext;IIILfoundation/algorand/xhdwalletapi/Bip32DerivationType;)[B", "rawSign", "data", "safeModQ", "input", "Ljava/math/BigInteger;", "signAlgoTransaction", "prefixEncodedTx", "signAlgoTransaction-EKTnNx0", "(Lfoundation/algorand/xhdwalletapi/KeyContext;III[BLfoundation/algorand/xhdwalletapi/Bip32DerivationType;)[B", "signData", "metadata", "Lfoundation/algorand/xhdwalletapi/SignMetadata;", "signData-fSESelo", "(Lfoundation/algorand/xhdwalletapi/KeyContext;III[BLfoundation/algorand/xhdwalletapi/SignMetadata;Lfoundation/algorand/xhdwalletapi/Bip32DerivationType;)[B", "trunc256MinusGBits", "zl", "g", "", "trunc256MinusGBits$XHDWalletAPI_Android_release", "verifyWithPublicKey", "signature", "message", "publicKey", "Companion", "XHDWalletAPI-Android_release"})
public abstract class XHDWalletAPIBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] seed;
    @NotNull
    private static final List<String> prefixes;

    public XHDWalletAPIBase(@NotNull byte[] seed) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        this.seed = seed;
    }

    @NotNull
    public abstract LazySodium getLazySodium();

    @NotNull
    public Pair<byte[], byte[]> deriveNonHardened-jXDDuk8(@NotNull byte[] kl, @NotNull byte[] cc, int index) {
        Intrinsics.checkNotNullParameter((Object)kl, (String)"kl");
        Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
        ByteBuffer data = ByteBuffer.allocate(1 + XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() + XHDWalletAPIBaseKt.getINDEX_SIZE());
        data.put(1 + XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE(), (byte)index);
        byte[] pk = this.getLazySodium().cryptoScalarMultEd25519BaseNoclamp(kl).toBytes();
        data.position(1);
        data.put(pk);
        data.put(0, (byte)2);
        Mac hmac = Mac.getInstance("HmacSHA512");
        hmac.init(new SecretKeySpec(cc, "HmacSHA512"));
        byte[] z = hmac.doFinal(data.array());
        data.put(0, (byte)3);
        hmac.init(new SecretKeySpec(cc, "HmacSHA512"));
        byte[] fullChildChainCode = hmac.doFinal(data.array());
        Intrinsics.checkNotNull((Object)fullChildChainCode);
        byte[] childChainCode = ArraysKt.sliceArray((byte[])fullChildChainCode, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE(), (int)(2 * XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE())));
        return new Pair((Object)z, (Object)childChainCode);
    }

    @NotNull
    public final Pair<byte[], byte[]> deriveHardened-hJeF8fQ$XHDWalletAPI_Android_release(@NotNull byte[] kl, @NotNull byte[] kr, @NotNull byte[] cc, int index) {
        Intrinsics.checkNotNullParameter((Object)kl, (String)"kl");
        Intrinsics.checkNotNullParameter((Object)kr, (String)"kr");
        Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
        int n = 0;
        byte[] byArray = new byte[4];
        while (n < 4) {
            int n2 = n++;
            byArray[n2] = (byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)(index >>> 8 * n2)) & 0xFF));
        }
        byte[] indexLEBytes = byArray;
        ByteBuffer data = ByteBuffer.allocate(1 + 2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() + XHDWalletAPIBaseKt.getINDEX_SIZE());
        data.position(1 + 2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE());
        data.put(indexLEBytes);
        data.position(1);
        data.put(kl);
        data.put(kr);
        data.put(0, (byte)0);
        Mac hmac = Mac.getInstance("HmacSHA512");
        hmac.init(new SecretKeySpec(cc, "HmacSHA512"));
        byte[] z = hmac.doFinal(data.array());
        data.put(0, (byte)1);
        hmac.init(new SecretKeySpec(cc, "HmacSHA512"));
        byte[] fullChildChainCode = hmac.doFinal(data.array());
        Intrinsics.checkNotNull((Object)fullChildChainCode);
        byte[] childChainCode = ArraysKt.sliceArray((byte[])fullChildChainCode, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE(), (int)(2 * XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE())));
        return new Pair((Object)z, (Object)childChainCode);
    }

    @NotNull
    public final byte[] deriveChildNodePrivate-OsBMiQA(@NotNull byte[] extendedKey, int index, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter((Object)extendedKey, (String)"extendedKey");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        byte[] kl = ArraysKt.sliceArray((byte[])extendedKey, (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()));
        byte[] kr = ArraysKt.sliceArray((byte[])extendedKey, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE(), (int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE())));
        byte[] cc = ArraysKt.sliceArray((byte[])extendedKey, (IntRange)RangesKt.until((int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()), (int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() + XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE())));
        Pair<byte[], byte[]> pair = Integer.compareUnsigned(index, UInt.constructor-impl((int)((int)0x80000000L))) < 0 ? this.deriveNonHardened-jXDDuk8(kl, cc, index) : this.deriveHardened-hJeF8fQ$XHDWalletAPI_Android_release(kl, kr, cc, index);
        byte[] z = (byte[])pair.component1();
        byte[] chainCode = (byte[])pair.component2();
        byte[] zl = ArraysKt.sliceArray((byte[])z, (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()));
        byte[] zr = ArraysKt.sliceArray((byte[])z, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE(), (int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE())));
        BigInteger bigInteger = new BigInteger(1, ArraysKt.reversedArray((byte[])kl));
        BigInteger bigInteger2 = new BigInteger(1, ArraysKt.reversedArray((byte[])this.trunc256MinusGBits$XHDWalletAPI_Android_release((byte[])zl.clone(), derivationType.getValue()))).multiply(BigInteger.valueOf(8L));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"multiply(...)");
        BigInteger bigInteger3 = bigInteger2;
        BigInteger bigInteger4 = bigInteger.add(bigInteger3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"add(...)");
        BigInteger leftBigInteger = bigInteger4;
        if (leftBigInteger.compareTo(BigInteger.valueOf(2L).pow(255)) >= 0) {
            throw new BigIntegerOverflowException();
        }
        byte[] byArray = leftBigInteger.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] bytes = ArraysKt.reversedArray((byte[])byArray);
        boolean bl = false;
        if (bytes.length > XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()) {
            throw new BigIntegerOverflowException();
        }
        byte[] left = ArraysKt.plus((byte[])new byte[XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() - bytes.length], (byte[])bytes);
        BigInteger bigInteger5 = new BigInteger(1, ArraysKt.reversedArray((byte[])kr)).add(new BigInteger(1, ArraysKt.reversedArray((byte[])zr)));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"add(...)");
        byte[] byArray2 = bigInteger5.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        byte[] bytes2 = ArraysKt.reversedArray((byte[])byArray2);
        boolean bl2 = false;
        byte[] right = ArraysKt.sliceArray((byte[])bytes2, (IntRange)RangesKt.until((int)0, (int)Math.min(bytes2.length, XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE())));
        right = ArraysKt.plus((byte[])right, (byte[])new byte[(XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() - right.length + 32) % 32]);
        byte[] byArray3 = ByteBuffer.allocate(XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() + XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() + XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE()).put(left).put(right).put(chainCode).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"array(...)");
        return byArray3;
    }

    public static /* synthetic */ byte[] deriveChildNodePrivate-OsBMiQA$default(XHDWalletAPIBase xHDWalletAPIBase, byte[] byArray, int n, Bip32DerivationType bip32DerivationType, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deriveChildNodePrivate-OsBMiQA");
        }
        if ((n2 & 4) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.deriveChildNodePrivate-OsBMiQA(byArray, n, bip32DerivationType);
    }

    @NotNull
    public final byte[] deriveChildNodePublic-OsBMiQA(@NotNull byte[] extendedKey, int index, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter((Object)extendedKey, (String)"extendedKey");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        if (Integer.compareUnsigned(index, Integer.MIN_VALUE) > 0) {
            throw new IllegalArgumentException("Cannot derive public key with hardened index");
        }
        byte[] pk = ArraysKt.sliceArray((byte[])extendedKey, (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_POINT_SIZE()));
        byte[] cc = ArraysKt.sliceArray((byte[])extendedKey, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getED25519_POINT_SIZE(), (int)(XHDWalletAPIBaseKt.getED25519_POINT_SIZE() + XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE())));
        ByteBuffer data = ByteBuffer.allocate(1 + XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() + 4);
        data.put(1 + XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE(), (byte)index);
        data.position(1);
        data.put(pk);
        data.put(0, (byte)2);
        Mac hmac = Mac.getInstance("HmacSHA512");
        hmac.init(new SecretKeySpec(cc, "HmacSHA512"));
        byte[] z = hmac.doFinal(data.array());
        Intrinsics.checkNotNull((Object)z);
        byte[] zl = this.trunc256MinusGBits$XHDWalletAPI_Android_release(ArraysKt.sliceArray((byte[])z, (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE())), derivationType.getValue());
        BigInteger bigInteger = new BigInteger(1, ArraysKt.reversedArray((byte[])zl));
        BigInteger bigInteger2 = BigInteger.valueOf(8L);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"multiply(...)");
        byte[] byArray = bigInteger3.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] bytes = ArraysKt.reversedArray((byte[])byArray);
        boolean bl = false;
        byte[] left = ArraysKt.plus((byte[])bytes, (byte[])new byte[XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() - bytes.length]);
        byte[] p = this.getLazySodium().cryptoScalarMultEd25519BaseNoclamp(left).toBytes();
        data.put(0, (byte)3);
        hmac.init(new SecretKeySpec(cc, "HmacSHA512"));
        byte[] fullChildChainCode = hmac.doFinal(data.array());
        Intrinsics.checkNotNull((Object)fullChildChainCode);
        byte[] childChainCode = ArraysKt.sliceArray((byte[])fullChildChainCode, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE(), (int)(2 * XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE())));
        byte[] newPK = new byte[32];
        this.getLazySodium().cryptoCoreEd25519Add(newPK, p, pk);
        byte[] byArray2 = ByteBuffer.allocate(XHDWalletAPIBaseKt.getED25519_POINT_SIZE() + XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE()).put(newPK).put(childChainCode).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
        return byArray2;
    }

    public static /* synthetic */ byte[] deriveChildNodePublic-OsBMiQA$default(XHDWalletAPIBase xHDWalletAPIBase, byte[] byArray, int n, Bip32DerivationType bip32DerivationType, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deriveChildNodePublic-OsBMiQA");
        }
        if ((n2 & 4) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.deriveChildNodePublic-OsBMiQA(byArray, n, bip32DerivationType);
    }

    @NotNull
    public final byte[] trunc256MinusGBits$XHDWalletAPI_Android_release(@NotNull byte[] zl, int g) {
        Intrinsics.checkNotNullParameter((Object)zl, (String)"zl");
        if (g < 0 || g > 256) {
            throw new IllegalArgumentException("Number of bits to zero must be between 0 and 256.");
        }
        byte[] truncated = zl;
        int remainingBits = g;
        for (int i = truncated.length - 1; -1 < i; --i) {
            if (remainingBits >= 8) {
                truncated[i] = 0;
                remainingBits -= 8;
                continue;
            }
            byte mask = (byte)((1 << 8 - remainingBits) - 1);
            truncated[i] = (byte)(truncated[i] & mask);
            break;
        }
        return truncated;
    }

    @NotNull
    public final byte[] deriveKey(@NotNull byte[] rootKey, @NotNull List<UInt> bip44Path, boolean isPrivate, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter((Object)rootKey, (String)"rootKey");
        Intrinsics.checkNotNullParameter(bip44Path, (String)"bip44Path");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        byte[] derived = rootKey;
        Iterator<UInt> iterator = bip44Path.iterator();
        while (iterator.hasNext()) {
            int path = iterator.next().unbox-impl();
            derived = this.deriveChildNodePrivate-OsBMiQA(derived, path, derivationType);
        }
        if (isPrivate) {
            return derived;
        }
        byte[] byArray = this.getLazySodium().cryptoScalarMultEd25519BaseNoclamp(ArraysKt.sliceArray((byte[])derived, (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()))).toBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toBytes(...)");
        return ArraysKt.plus((byte[])byArray, (byte[])ArraysKt.sliceArray((byte[])derived, (IntRange)RangesKt.until((int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()), (int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE() + XHDWalletAPIBaseKt.getCHAIN_CODE_SIZE()))));
    }

    public static /* synthetic */ byte[] deriveKey$default(XHDWalletAPIBase xHDWalletAPIBase, byte[] byArray, List list, boolean bl, Bip32DerivationType bip32DerivationType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deriveKey");
        }
        if ((n & 8) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.deriveKey(byArray, list, bl, bip32DerivationType);
    }

    @NotNull
    public final byte[] keyGen-G2O0Dqo(@NotNull KeyContext context, int account, int change, int keyIndex, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        byte[] rootKey = Companion.fromSeed(this.seed);
        List<UInt> bip44Path = Companion.getBIP44PathFromContext-7IvYBaQ(context, account, change, keyIndex);
        return ArraysKt.sliceArray((byte[])this.deriveKey(rootKey, bip44Path, false, derivationType), (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_POINT_SIZE()));
    }

    public static /* synthetic */ byte[] keyGen-G2O0Dqo$default(XHDWalletAPIBase xHDWalletAPIBase, KeyContext keyContext, int n, int n2, int n3, Bip32DerivationType bip32DerivationType, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: keyGen-G2O0Dqo");
        }
        if ((n4 & 0x10) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.keyGen-G2O0Dqo(keyContext, n, n2, n3, bip32DerivationType);
    }

    @NotNull
    public final byte[] signData-fSESelo(@NotNull KeyContext context, int account, int change, int keyIndex, @NotNull byte[] data, @NotNull SignMetadata metadata, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        boolean valid = Companion.validateData(data, metadata);
        if (!valid) {
            throw new DataValidationException("Data validation failed");
        }
        return this.rawSign(Companion.getBIP44PathFromContext-7IvYBaQ(context, account, change, keyIndex), data, derivationType);
    }

    public static /* synthetic */ byte[] signData-fSESelo$default(XHDWalletAPIBase xHDWalletAPIBase, KeyContext keyContext, int n, int n2, int n3, byte[] byArray, SignMetadata signMetadata, Bip32DerivationType bip32DerivationType, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: signData-fSESelo");
        }
        if ((n4 & 0x40) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.signData-fSESelo(keyContext, n, n2, n3, byArray, signMetadata, bip32DerivationType);
    }

    @NotNull
    public final byte[] signAlgoTransaction-EKTnNx0(@NotNull KeyContext context, int account, int change, int keyIndex, @NotNull byte[] prefixEncodedTx, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)prefixEncodedTx, (String)"prefixEncodedTx");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        return this.rawSign(Companion.getBIP44PathFromContext-7IvYBaQ(context, account, change, keyIndex), prefixEncodedTx, derivationType);
    }

    public static /* synthetic */ byte[] signAlgoTransaction-EKTnNx0$default(XHDWalletAPIBase xHDWalletAPIBase, KeyContext keyContext, int n, int n2, int n3, byte[] byArray, Bip32DerivationType bip32DerivationType, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: signAlgoTransaction-EKTnNx0");
        }
        if ((n4 & 0x20) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.signAlgoTransaction-EKTnNx0(keyContext, n, n2, n3, byArray, bip32DerivationType);
    }

    @NotNull
    public final byte[] rawSign(@NotNull List<UInt> bip44Path, @NotNull byte[] data, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter(bip44Path, (String)"bip44Path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        byte[] rootKey = Companion.fromSeed(this.seed);
        byte[] raw = this.deriveKey(rootKey, bip44Path, true, derivationType);
        byte[] scalar = ArraysKt.sliceArray((byte[])raw, (IntRange)RangesKt.until((int)0, (int)32));
        byte[] c = ArraysKt.sliceArray((byte[])raw, (IntRange)RangesKt.until((int)32, (int)64));
        byte[] publicKey = this.getLazySodium().cryptoScalarMultEd25519BaseNoclamp(scalar).toBytes();
        byte[] byArray = MessageDigest.getInstance("SHA-512").digest(ArraysKt.plus((byte[])c, (byte[])data));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        byte[] r = this.safeModQ(byArray);
        byte[] R = this.getLazySodium().cryptoScalarMultEd25519BaseNoclamp(r).toBytes();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        Intrinsics.checkNotNull((Object)R);
        Intrinsics.checkNotNull((Object)publicKey);
        byte[] byArray2 = messageDigest.digest(ArraysKt.plus((byte[])ArraysKt.plus((byte[])R, (byte[])publicKey), (byte[])data));
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        byte[] h = this.safeModQ(byArray2);
        LazySodium lazySodium = this.getLazySodium();
        byte[] byArray3 = this.getLazySodium().cryptoCoreEd25519ScalarMul(h, scalar).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
        BigInteger bigInteger = lazySodium.cryptoCoreEd25519ScalarAdd(r, ArraysKt.reversedArray((byte[])byArray3));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"cryptoCoreEd25519ScalarAdd(...)");
        byte[] S = this.safeModQ(bigInteger);
        return ArraysKt.plus((byte[])R, (byte[])S);
    }

    public static /* synthetic */ byte[] rawSign$default(XHDWalletAPIBase xHDWalletAPIBase, List list, byte[] byArray, Bip32DerivationType bip32DerivationType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rawSign");
        }
        if ((n & 4) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.rawSign(list, byArray, bip32DerivationType);
    }

    @NotNull
    public final byte[] safeModQ(@NotNull BigInteger input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] byArray = this.getLazySodium().cryptoCoreEd25519ScalarReduce(input).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] reduced = ArraysKt.reversedArray((byte[])byArray);
        if (reduced.length < 32) {
            reduced = ArraysKt.plus((byte[])reduced, (byte[])new byte[32 - reduced.length]);
        }
        return reduced;
    }

    @NotNull
    public final byte[] safeModQ(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] byArray = this.getLazySodium().cryptoCoreEd25519ScalarReduce(input).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] reduced = ArraysKt.reversedArray((byte[])byArray);
        if (reduced.length < 32) {
            reduced = ArraysKt.plus((byte[])reduced, (byte[])new byte[32 - reduced.length]);
        }
        return reduced;
    }

    public final boolean verifyWithPublicKey(@NotNull byte[] signature, @NotNull byte[] message, @NotNull byte[] publicKey) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return this.getLazySodium().cryptoSignVerifyDetached(signature, message, message.length, publicKey);
    }

    @NotNull
    public final byte[] ECDH-fSESelo(@NotNull KeyContext context, int account, int change, int keyIndex, @NotNull byte[] otherPartyPub, boolean meFirst, @NotNull Bip32DerivationType derivationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Intrinsics.checkNotNullParameter((Object)otherPartyPub, (String)"otherPartyPub");
        Intrinsics.checkNotNullParameter((Object)((Object)derivationType), (String)"derivationType");
        byte[] rootKey = Companion.fromSeed(this.seed);
        byte[] publicKey = this.keyGen-G2O0Dqo(context, account, change, keyIndex, derivationType);
        byte[] privateKey = this.deriveKey(rootKey, Companion.getBIP44PathFromContext-7IvYBaQ(context, account, change, keyIndex), true, derivationType);
        byte[] scalar = ArraysKt.sliceArray((byte[])privateKey, (IntRange)RangesKt.until((int)0, (int)32));
        byte[] sharedPoint = new byte[32];
        byte[] myCurve25519Key = new byte[32];
        byte[] otherPartyCurve25519Key = new byte[32];
        this.getLazySodium().convertPublicKeyEd25519ToCurve25519(myCurve25519Key, publicKey);
        this.getLazySodium().convertPublicKeyEd25519ToCurve25519(otherPartyCurve25519Key, otherPartyPub);
        this.getLazySodium().cryptoScalarMult(sharedPoint, scalar, otherPartyCurve25519Key);
        byte[] concatenated = null;
        concatenated = meFirst ? ArraysKt.plus((byte[])ArraysKt.plus((byte[])sharedPoint, (byte[])myCurve25519Key), (byte[])otherPartyCurve25519Key) : ArraysKt.plus((byte[])ArraysKt.plus((byte[])sharedPoint, (byte[])otherPartyCurve25519Key), (byte[])myCurve25519Key);
        byte[] output = new byte[32];
        this.getLazySodium().cryptoGenericHash(output, 32, concatenated, (long)concatenated.length);
        return output;
    }

    public static /* synthetic */ byte[] ECDH-fSESelo$default(XHDWalletAPIBase xHDWalletAPIBase, KeyContext keyContext, int n, int n2, int n3, byte[] byArray, boolean bl, Bip32DerivationType bip32DerivationType, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ECDH-fSESelo");
        }
        if ((n4 & 0x40) != 0) {
            bip32DerivationType = Bip32DerivationType.Peikert;
        }
        return xHDWalletAPIBase.ECDH-fSESelo(keyContext, n, n2, n3, byArray, bl, bip32DerivationType);
    }

    static {
        Object[] objectArray = new String[]{"appID", "arc", "aB", "aD", "aO", "aP", "aS", "AS", "BH", "B256", "BR", "CR", "GE", "KP", "MA", "MB", "MX", "NIC", "NIR", "NIV", "NPR", "OT1", "OT2", "PF", "PL", "Program", "ProgData", "PS", "PK", "SD", "SpecialAddr", "STIB", "spc", "spm", "spp", "sps", "spv", "TE", "TG", "TL", "TX", "VO"};
        prefixes = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ6\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tJ\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001e"}, d2={"Lfoundation/algorand/xhdwalletapi/XHDWalletAPIBase$Companion;", "", "()V", "prefixes", "", "", "getPrefixes", "()Ljava/util/List;", "fromSeed", "", "seed", "getBIP44PathFromContext", "Lkotlin/UInt;", "context", "Lfoundation/algorand/xhdwalletapi/KeyContext;", "account", "change", "keyIndex", "getBIP44PathFromContext-7IvYBaQ", "(Lfoundation/algorand/xhdwalletapi/KeyContext;III)Ljava/util/List;", "harden", "num", "harden-IKrLr70", "(I)I", "hasAlgorandTags", "", "message", "validateData", "metadata", "Lfoundation/algorand/xhdwalletapi/SignMetadata;", "XHDWalletAPI-Android_release"})
    @SourceDebugExtension(value={"SMAP\nXHDWalletAPIBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XHDWalletAPIBase.kt\nfoundation/algorand/xhdwalletapi/XHDWalletAPIBase$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,770:1\n1747#2,3:771\n*S KotlinDebug\n*F\n+ 1 XHDWalletAPIBase.kt\nfoundation/algorand/xhdwalletapi/XHDWalletAPIBase$Companion\n*L\n163#1:771,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPrefixes() {
            return prefixes;
        }

        public final int harden-IKrLr70(int num) {
            return UInt.constructor-impl((int)(UInt.constructor-impl((int)((int)0x80000000L)) + num));
        }

        @NotNull
        public final List<UInt> getBIP44PathFromContext-7IvYBaQ(@NotNull KeyContext context, int account, int change, int keyIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            return switch (WhenMappings.$EnumSwitchMapping$0[context.ordinal()]) {
                case 1 -> {
                    Object[] var5_5 = new UInt[]{UInt.box-impl((int)this.harden-IKrLr70(44)), UInt.box-impl((int)this.harden-IKrLr70(283)), UInt.box-impl((int)this.harden-IKrLr70(account)), UInt.box-impl((int)change), UInt.box-impl((int)keyIndex)};
                    yield CollectionsKt.listOf((Object[])var5_5);
                }
                case 2 -> {
                    Object[] var5_6 = new UInt[]{UInt.box-impl((int)this.harden-IKrLr70(44)), UInt.box-impl((int)this.harden-IKrLr70(0)), UInt.box-impl((int)this.harden-IKrLr70(account)), UInt.box-impl((int)change), UInt.box-impl((int)keyIndex)};
                    yield CollectionsKt.listOf((Object[])var5_6);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public final boolean validateData(@NotNull byte[] message, @NotNull SignMetadata metadata) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            if (this.hasAlgorandTags(message)) {
                throw new DataValidationException("Data contains Algorand tags");
            }
            switch (WhenMappings.$EnumSwitchMapping$1[metadata.getEncoding().ordinal()]) {
                case 1: {
                    byte[] byArray2 = Base64.getDecoder().decode(message);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
                    break;
                }
                case 2: {
                    String string = new ObjectMapper().writeValueAsString(new ObjectMapper((JsonFactory)new MessagePackFactory()).readValue(message, Map.class));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
                    String string2 = string;
                    byte[] byArray3 = string2.getBytes(Charsets.UTF_8);
                    byArray = byArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                    break;
                }
                case 3: {
                    byArray = message;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            byte[] decoded = byArray;
            try {
                return JSONSchema.validateBasic$default((JSONSchema)metadata.getSchema(), (String)new String(decoded, Charsets.UTF_8), null, (int)2, null).getValid();
            }
            catch (Exception e) {
                return false;
            }
        }

        public final boolean hasAlgorandTags(@NotNull byte[] message) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String messageString = new String(message, Charsets.UTF_8);
                Iterable $this$any$iv = this.getPrefixes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)messageString, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final byte[] fromSeed(@NotNull byte[] seed) {
            byte[] byArray;
            byte[] k;
            Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
            byte[] byArray2 = k = MessageDigest.getInstance("SHA-512").digest(seed);
            Intrinsics.checkNotNull((Object)byArray2);
            byte[] kL = ArraysKt.sliceArray((byte[])byArray2, (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()));
            byte[] byArray3 = k;
            Intrinsics.checkNotNull((Object)byArray3);
            byte[] kR = ArraysKt.sliceArray((byte[])byArray3, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE(), (int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE())));
            while ((kL[31] & 0x20) != 0) {
                Mac hmac = Mac.getInstance("HmacSHA512");
                hmac.init(new SecretKeySpec(kL, "HmacSHA512"));
                byArray = k = hmac.doFinal(kR);
                Intrinsics.checkNotNull((Object)byArray);
                kL = ArraysKt.sliceArray((byte[])byArray, (IntRange)RangesKt.until((int)0, (int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE()));
                byArray = k;
                Intrinsics.checkNotNull((Object)byArray);
                kR = ArraysKt.sliceArray((byte[])byArray, (IntRange)RangesKt.until((int)XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE(), (int)(2 * XHDWalletAPIBaseKt.getED25519_SCALAR_SIZE())));
            }
            kL[0] = (byte)(kL[0] & 0xF8);
            kL[31] = (byte)(kL[31] & 0x7F);
            kL[31] = (byte)(kL[31] | 0x40);
            byArray = new byte[]{1};
            byte[] c = MessageDigest.getInstance("SHA-256").digest(ArraysKt.plus((byte[])byArray, (byte[])seed));
            byte[] byArray4 = ArraysKt.plus((byte[])kL, (byte[])kR);
            Intrinsics.checkNotNull((Object)c);
            return ArraysKt.plus((byte[])byArray4, (byte[])c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[KeyContext.values().length];
                try {
                    nArray[KeyContext.Address.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KeyContext.Identity.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Encoding.values().length];
                try {
                    nArray[Encoding.BASE64.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Encoding.MSGPACK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Encoding.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

