/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.interfaces;

import com.goterl.lazysodium.LazySodium;
import com.goterl.lazysodium.exceptions.SodiumException;
import java.math.BigInteger;
import java.util.Arrays;

public interface Ed25519 {
    public static final int ED25519_BYTES = 32;
    public static final int ED25519_HASH_BYTES = 64;
    public static final int ED25519_SCALAR_BYTES = 32;
    public static final int ED25519_NON_REDUCED_SCALAR_BYTES = 64;
    public static final BigInteger ED25519_L = BigInteger.valueOf(2L).pow(252).add(new BigInteger("27742317777372353535851937790883648493", 10));

    public static byte[] scalarToBytes(BigInteger n) {
        return Ed25519.scalarToBytes(n, true);
    }

    public static byte[] scalarToBytes(BigInteger n, boolean reduced) {
        int expectedCount;
        byte[] bigEndianBytes = n.toByteArray();
        int n2 = expectedCount = reduced ? 32 : 64;
        if (bigEndianBytes.length > expectedCount) {
            throw new IllegalArgumentException("The scalar value is too big to be represented in " + expectedCount + " bytes");
        }
        byte[] littleEndianBytes = new byte[expectedCount];
        for (int i = 0; i < bigEndianBytes.length; ++i) {
            littleEndianBytes[i] = bigEndianBytes[bigEndianBytes.length - i - 1];
        }
        return littleEndianBytes;
    }

    public static BigInteger bytesToScalar(byte[] bytes) {
        byte[] temp = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            temp[bytes.length - i - 1] = bytes[i];
        }
        return new BigInteger(temp);
    }

    public static byte[] pointBuffer() {
        return new byte[32];
    }

    public static byte[] scalarBuffer() {
        return new byte[32];
    }

    public static final class Ed25519Point {
        private final LazySodium ls;
        private final byte[] repr;

        private Ed25519Point(LazySodium ls, byte[] repr) {
            if (repr == null || !ls.cryptoCoreEd25519IsValidPoint(repr)) {
                throw new IllegalArgumentException("The passed point is invalid");
            }
            this.repr = repr;
            this.ls = ls;
        }

        private Ed25519Point(LazySodium ls, String encoded) {
            this(ls, ls.decodeFromString(encoded));
        }

        public String toString() {
            return this.encode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ed25519Point)) {
                return false;
            }
            Ed25519Point that = (Ed25519Point)o;
            return Arrays.equals(this.repr, that.repr);
        }

        public int hashCode() {
            return Arrays.hashCode(this.repr);
        }

        public String toHex() {
            return this.ls.toHexStr(this.repr);
        }

        public byte[] toBytes() {
            return this.repr;
        }

        public String encode() {
            return this.ls.encodeToString(this.repr);
        }

        public Ed25519Point scalarMult(BigInteger n) throws SodiumException {
            return this.ls.cryptoScalarMultEd25519Noclamp(n, this);
        }

        public Ed25519Point times(BigInteger n) throws SodiumException {
            return this.scalarMult(n);
        }

        public Ed25519Point plus(Ed25519Point other) throws SodiumException {
            return this.ls.cryptoCoreEd25519Add(this, other);
        }

        public Ed25519Point minus(Ed25519Point other) throws SodiumException {
            return this.ls.cryptoCoreEd25519Sub(this, other);
        }

        public Ed25519Point negate() throws SodiumException {
            return Ed25519Point.zero(this.ls).minus(this);
        }

        public static Ed25519Point zero(LazySodium ls) {
            return Ed25519Point.fromBytes(ls, Ed25519.pointBuffer());
        }

        public static Ed25519Point random(LazySodium ls) {
            return ls.cryptoCoreEd25519Random();
        }

        public static Ed25519Point base(LazySodium ls) throws SodiumException {
            return ls.cryptoScalarMultEd25519BaseNoclamp(BigInteger.ONE);
        }

        public static Ed25519Point fromHex(LazySodium ls, String hex) {
            return new Ed25519Point(ls, ls.toBinary(hex));
        }

        public static Ed25519Point fromString(LazySodium ls, String encoded) {
            return new Ed25519Point(ls, encoded);
        }

        public static Ed25519Point fromBytes(LazySodium ls, byte[] bytes) {
            return new Ed25519Point(ls, bytes);
        }

        public static Ed25519Point hashToPoint(LazySodium ls, String encodedInput) throws SodiumException {
            return Ed25519Point.hashToPoint(ls, ls.decodeFromString(encodedInput));
        }

        public static Ed25519Point hashToPoint(LazySodium ls, byte[] input) throws SodiumException {
            byte[] hash = new byte[64];
            ls.cryptoHashSha512(hash, input, input.length);
            return ls.cryptoCoreEd25519FromUniform(hash);
        }
    }

    public static class Checker {
        private Checker() {
        }

        public static void ensurePointFits(byte[] point) {
            if (point == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as target arrays");
            }
            if (point.length < 32) {
                throw new IllegalArgumentException("To hold a Ed25519 point, the array must be 32 bytes in size");
            }
        }

        public static void ensureScalarFits(byte[] scalar) {
            if (scalar == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as target arrays");
            }
            if (scalar.length < 32) {
                throw new IllegalArgumentException("To hold a Ed25519 scalar, the array must be 32 bytes in size");
            }
        }

        public static void checkPoint(byte[] point) {
            if (point == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as Ed25519 points");
            }
            if (point.length != 32) {
                throw new IllegalArgumentException("A Ed25519 point must be 32 bytes in size");
            }
        }

        public static void checkHash(byte[] hash) {
            if (hash == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as Ed25519 hashes");
            }
            if (hash.length != 64) {
                throw new IllegalArgumentException("A hash for use with Ed25519 must be 64 bytes in size");
            }
        }

        public static void checkScalar(byte[] scalar) {
            if (scalar == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as Ed25519 scalars");
            }
            if (scalar.length != 32) {
                throw new IllegalArgumentException("A Ed25519 scalar must be 32 bytes in size");
            }
        }

        public static void checkNonReducedScalar(byte[] scalar) {
            if (scalar == null) {
                throw new IllegalArgumentException("Null pointers are not allowed as non-reduced Ed25519 scalars");
            }
            if (scalar.length != 64) {
                throw new IllegalArgumentException("A non-reduced Ed25519 scalar must be 64 bytes in size");
            }
        }
    }

    public static interface Lazy {
        public boolean cryptoCoreEd25519IsValidPoint(String var1);

        public Ed25519Point cryptoCoreEd25519Random();

        public Ed25519Point cryptoCoreEd25519FromUniform(String var1) throws SodiumException;

        public Ed25519Point cryptoCoreEd25519FromUniform(byte[] var1) throws SodiumException;

        public Ed25519Point cryptoScalarMultEd25519Noclamp(BigInteger var1, Ed25519Point var2) throws SodiumException;

        public Ed25519Point cryptoScalarMultEd25519Noclamp(String var1, Ed25519Point var2) throws SodiumException;

        public Ed25519Point cryptoScalarMultEd25519Noclamp(byte[] var1, Ed25519Point var2) throws SodiumException;

        public Ed25519Point cryptoScalarMultEd25519BaseNoclamp(BigInteger var1) throws SodiumException;

        public Ed25519Point cryptoScalarMultEd25519BaseNoclamp(String var1) throws SodiumException;

        public Ed25519Point cryptoScalarMultEd25519BaseNoclamp(byte[] var1) throws SodiumException;

        public Ed25519Point cryptoCoreEd25519Add(Ed25519Point var1, Ed25519Point var2) throws SodiumException;

        public Ed25519Point cryptoCoreEd25519Sub(Ed25519Point var1, Ed25519Point var2) throws SodiumException;

        public BigInteger cryptoCoreEd25519ScalarRandom();

        public BigInteger cryptoCoreEd25519ScalarReduce(BigInteger var1);

        public BigInteger cryptoCoreEd25519ScalarReduce(String var1);

        public BigInteger cryptoCoreEd25519ScalarReduce(byte[] var1);

        public BigInteger cryptoCoreEd25519ScalarInvert(BigInteger var1) throws SodiumException;

        public BigInteger cryptoCoreEd25519ScalarInvert(String var1) throws SodiumException;

        public BigInteger cryptoCoreEd25519ScalarInvert(byte[] var1) throws SodiumException;

        public BigInteger cryptoCoreEd25519ScalarNegate(BigInteger var1);

        public BigInteger cryptoCoreEd25519ScalarNegate(String var1);

        public BigInteger cryptoCoreEd25519ScalarNegate(byte[] var1);

        public BigInteger cryptoCoreEd25519ScalarComplement(BigInteger var1);

        public BigInteger cryptoCoreEd25519ScalarComplement(String var1);

        public BigInteger cryptoCoreEd25519ScalarComplement(byte[] var1);

        public BigInteger cryptoCoreEd25519ScalarAdd(BigInteger var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(BigInteger var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(String var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(String var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(String var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(byte[] var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(BigInteger var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(byte[] var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarAdd(byte[] var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarSub(BigInteger var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarSub(BigInteger var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarSub(String var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarSub(String var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarSub(String var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarSub(byte[] var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarSub(BigInteger var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarSub(byte[] var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarSub(byte[] var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarMul(BigInteger var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarMul(BigInteger var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarMul(String var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarMul(String var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarMul(String var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarMul(byte[] var1, String var2);

        public BigInteger cryptoCoreEd25519ScalarMul(BigInteger var1, byte[] var2);

        public BigInteger cryptoCoreEd25519ScalarMul(byte[] var1, BigInteger var2);

        public BigInteger cryptoCoreEd25519ScalarMul(byte[] var1, byte[] var2);
    }

    public static interface Native {
        public boolean cryptoCoreEd25519IsValidPoint(byte[] var1);

        public void cryptoCoreEd25519Random(byte[] var1);

        public boolean cryptoCoreEd25519FromUniform(byte[] var1, byte[] var2);

        public boolean cryptoScalarMultEd25519Noclamp(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoScalarMultEd25519BaseNoclamp(byte[] var1, byte[] var2);

        public boolean cryptoCoreEd25519Add(byte[] var1, byte[] var2, byte[] var3);

        public boolean cryptoCoreEd25519Sub(byte[] var1, byte[] var2, byte[] var3);

        public void cryptoCoreEd25519ScalarRandom(byte[] var1);

        public void cryptoCoreEd25519ScalarReduce(byte[] var1, byte[] var2);

        public boolean cryptoCoreEd25519ScalarInvert(byte[] var1, byte[] var2);

        public void cryptoCoreEd25519ScalarNegate(byte[] var1, byte[] var2);

        public void cryptoCoreEd25519ScalarComplement(byte[] var1, byte[] var2);

        public void cryptoCoreEd25519ScalarAdd(byte[] var1, byte[] var2, byte[] var3);

        public void cryptoCoreEd25519ScalarSub(byte[] var1, byte[] var2, byte[] var3);

        public void cryptoCoreEd25519ScalarMul(byte[] var1, byte[] var2, byte[] var3);
    }
}

