/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.crypto;

import foundation.icon.icx.crypto.IconKeys;
import foundation.icon.icx.crypto.KeystoreException;
import foundation.icon.icx.crypto.KeystoreFile;
import foundation.icon.icx.data.Bytes;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.util.encoders.Hex;

public class Keystore {
    private static final int N_LIGHT = 4096;
    private static final int P_LIGHT = 6;
    private static final int N_STANDARD = 262144;
    private static final int P_STANDARD = 1;
    private static final int R = 8;
    private static final int DKLEN = 32;
    private static final int CURRENT_VERSION = 3;
    private static final String CIPHER = "aes-128-ctr";
    static final String AES_128_CTR = "pbkdf2";
    static final String SCRYPT = "scrypt";

    public static KeystoreFile create(String password, Bytes privateKey, int n, int p) throws KeystoreException {
        byte[] salt = Keystore.generateRandomBytes(32);
        byte[] derivedKey = Keystore.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, n, 8, p, 32);
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        byte[] iv = Keystore.generateRandomBytes(16);
        byte[] privateKeyBytes = privateKey.toByteArray(32);
        byte[] cipherText = Keystore.performCipherOperation(1, iv, encryptKey, privateKeyBytes);
        byte[] mac = Keystore.generateMac(derivedKey, cipherText);
        return Keystore.createWalletFile(privateKey, cipherText, iv, salt, mac, n, p);
    }

    private static KeystoreFile createWalletFile(Bytes privateKey, byte[] cipherText, byte[] iv, byte[] salt, byte[] mac, int n, int p) {
        KeystoreFile keystoreFile = new KeystoreFile();
        keystoreFile.setAddress(IconKeys.getAddress(IconKeys.getPublicKey(privateKey)));
        KeystoreFile.Crypto crypto = new KeystoreFile.Crypto();
        crypto.setCipher(CIPHER);
        crypto.setCiphertext(Hex.toHexString((byte[])cipherText));
        keystoreFile.setCrypto(crypto);
        KeystoreFile.CipherParams cipherParams = new KeystoreFile.CipherParams();
        cipherParams.setIv(Hex.toHexString((byte[])iv));
        crypto.setCipherparams(cipherParams);
        crypto.setKdf(SCRYPT);
        KeystoreFile.ScryptKdfParams kdfParams = new KeystoreFile.ScryptKdfParams();
        kdfParams.setDklen(32);
        kdfParams.setN(n);
        kdfParams.setP(p);
        kdfParams.setR(8);
        kdfParams.setSalt(Hex.toHexString((byte[])salt));
        crypto.setKdfparams(kdfParams);
        crypto.setMac(Hex.toHexString((byte[])mac));
        keystoreFile.setCrypto(crypto);
        keystoreFile.setId(UUID.randomUUID().toString());
        keystoreFile.setVersion(3);
        keystoreFile.setCoinType("icx");
        return keystoreFile;
    }

    private static byte[] generateDerivedScryptKey(byte[] password, byte[] salt, int n, int r, int p, int dkLen) {
        return SCrypt.generate((byte[])password, (byte[])salt, (int)n, (int)r, (int)p, (int)dkLen);
    }

    private static byte[] generateAes128CtrDerivedKey(byte[] password, byte[] salt, int c, String prf) throws KeystoreException {
        if (!prf.equals("hmac-sha256")) {
            throw new KeystoreException("Unsupported prf:" + prf);
        }
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(password, salt, c);
        return ((KeyParameter)gen.generateDerivedParameters(256)).getKey();
    }

    private static byte[] performCipherOperation(int mode, byte[] iv, byte[] encryptKey, byte[] text) throws KeystoreException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(encryptKey, "AES");
            cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
            return cipher.doFinal(text);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new KeystoreException("Error performing cipher operation", e);
        }
    }

    private static byte[] generateMac(byte[] derivedKey, byte[] cipherText) {
        byte[] result = new byte[16 + cipherText.length];
        System.arraycopy(derivedKey, 16, result, 0, 16);
        System.arraycopy(cipherText, 0, result, 16, cipherText.length);
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(result, 0, result.length);
        return kecc.digest();
    }

    public static Bytes decrypt(String password, KeystoreFile keystoreFile) throws KeystoreException {
        byte[] derivedKey;
        Keystore.validate(keystoreFile);
        KeystoreFile.Crypto crypto = keystoreFile.getCrypto();
        byte[] mac = Hex.decode((String)crypto.getMac());
        byte[] iv = Hex.decode((String)crypto.getCipherparams().getIv());
        byte[] cipherText = Hex.decode((String)crypto.getCiphertext());
        KeystoreFile.KdfParams kdfParams = crypto.getKdfparams();
        if (kdfParams instanceof KeystoreFile.ScryptKdfParams) {
            KeystoreFile.ScryptKdfParams scryptKdfParams = (KeystoreFile.ScryptKdfParams)crypto.getKdfparams();
            int dklen = scryptKdfParams.getDklen();
            int n = scryptKdfParams.getN();
            int p = scryptKdfParams.getP();
            int r = scryptKdfParams.getR();
            byte[] salt = Hex.decode((String)scryptKdfParams.getSalt());
            derivedKey = Keystore.generateDerivedScryptKey(password.getBytes(StandardCharsets.UTF_8), salt, n, r, p, dklen);
        } else if (kdfParams instanceof KeystoreFile.Aes128CtrKdfParams) {
            KeystoreFile.Aes128CtrKdfParams aes128CtrKdfParams = (KeystoreFile.Aes128CtrKdfParams)crypto.getKdfparams();
            int c = aes128CtrKdfParams.getC();
            String prf = aes128CtrKdfParams.getPrf();
            byte[] salt = Hex.decode((String)aes128CtrKdfParams.getSalt());
            derivedKey = Keystore.generateAes128CtrDerivedKey(password.getBytes(StandardCharsets.UTF_8), salt, c, prf);
        } else {
            throw new KeystoreException("Unable to deserialize params: " + crypto.getKdf());
        }
        byte[] derivedMac = Keystore.generateMac(derivedKey, cipherText);
        if (!Arrays.equals(derivedMac, mac)) {
            throw new KeystoreException("Invalid password provided");
        }
        byte[] encryptKey = Arrays.copyOfRange(derivedKey, 0, 16);
        byte[] privateKey = Keystore.performCipherOperation(2, iv, encryptKey, cipherText);
        return new Bytes(privateKey);
    }

    private static void validate(KeystoreFile keystoreFile) throws KeystoreException {
        KeystoreFile.Crypto crypto = keystoreFile.getCrypto();
        if (keystoreFile.getVersion() != 3) {
            throw new KeystoreException("Keystore version is not supported");
        }
        if (!crypto.getCipher().equals(CIPHER)) {
            throw new KeystoreException("Keystore cipher is not supported");
        }
        if (!crypto.getKdf().equals(AES_128_CTR) && !crypto.getKdf().equals(SCRYPT)) {
            throw new KeystoreException("KDF type is not supported");
        }
        if (keystoreFile.getCoinType() == null || !keystoreFile.getCoinType().equalsIgnoreCase("icx")) {
            throw new KeystoreException("Invalid Keystore file");
        }
    }

    private static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        IconKeys.secureRandom().nextBytes(bytes);
        return bytes;
    }
}

