/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.ConfirmedTransaction;
import foundation.icon.icx.data.Converters;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Block {
    private final RpcObject properties;

    Block(RpcObject properties) {
        this.properties = properties;
    }

    public RpcObject getProperties() {
        return this.properties;
    }

    public Bytes getPrevBlockHash() {
        RpcItem item = this.properties.getItem("prev_block_hash");
        return item != null ? item.asBytes() : null;
    }

    public Bytes getMerkleTreeRootHash() {
        RpcItem item = this.properties.getItem("merkle_tree_root_hash");
        return item != null ? item.asBytes() : null;
    }

    public BigInteger getTimestamp() {
        RpcItem item = this.properties.getItem("time_stamp");
        return item != null ? item.asInteger() : null;
    }

    public List<ConfirmedTransaction> getTransactions() {
        RpcItem item = this.properties.getItem("confirmed_transaction_list");
        ArrayList<ConfirmedTransaction> transactions = new ArrayList<ConfirmedTransaction>();
        if (item != null && this.getHeight().intValue() > 0) {
            for (RpcItem tx : item.asArray()) {
                transactions.add(Converters.CONFIRMED_TRANSACTION.convertTo(tx.asObject()));
            }
        }
        return transactions;
    }

    public Bytes getBlockHash() {
        RpcItem item = this.properties.getItem("block_hash");
        return item != null ? item.asBytes() : null;
    }

    public String getPeerId() {
        RpcItem item = this.properties.getItem("peer_id");
        return item != null ? item.asString() : null;
    }

    public BigInteger getVersion() {
        RpcItem item = this.properties.getItem("version");
        return item != null ? item.asInteger() : null;
    }

    public BigInteger getHeight() {
        RpcItem item = this.properties.getItem("height");
        return item != null ? item.asInteger() : null;
    }

    public String getSignature() {
        RpcItem item = this.properties.getItem("signature");
        return item != null ? item.asString() : null;
    }

    public String toString() {
        return "Block{properties=" + this.properties + '}';
    }
}

