/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;

public class BlockNotification {
    private final RpcObject properties;

    BlockNotification(RpcObject properties) {
        this.properties = properties;
    }

    public Bytes getHash() {
        RpcItem item = this.properties.getItem("hash");
        return item != null ? item.asBytes() : null;
    }

    public BigInteger getHeight() {
        return BlockNotification.asInteger(this.properties.getItem("height"));
    }

    public BigInteger[][] getIndexes() {
        return BlockNotification.asIntegerArrayArray(this.properties.getItem("indexes"));
    }

    public BigInteger[][][] getEvents() {
        RpcItem item = this.properties.getItem("events");
        BigInteger[][][] events = null;
        if (item != null) {
            RpcArray rpcArray = item.asArray();
            int size = rpcArray.size();
            events = new BigInteger[size][][];
            for (int i = 0; i < size; ++i) {
                events[i] = BlockNotification.asIntegerArrayArray(rpcArray.get(i));
            }
        }
        return events;
    }

    public static BigInteger[][] asIntegerArrayArray(RpcItem item) {
        BigInteger[][] arr = null;
        if (item != null) {
            RpcArray rpcArray = item.asArray();
            int size = rpcArray.size();
            arr = new BigInteger[size][];
            for (int i = 0; i < size; ++i) {
                arr[i] = BlockNotification.asIntegerArray(rpcArray.get(i));
            }
        }
        return arr;
    }

    public static BigInteger[] asIntegerArray(RpcItem item) {
        BigInteger[] arr = null;
        if (item != null) {
            RpcArray rpcArray = item.asArray();
            int size = rpcArray.size();
            arr = new BigInteger[size];
            for (int i = 0; i < size; ++i) {
                arr[i] = BlockNotification.asInteger(rpcArray.get(i));
            }
        }
        return arr;
    }

    public static BigInteger asInteger(RpcItem item) {
        return item != null ? item.asInteger() : null;
    }
}

