/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;

public class EventNotification {
    private final RpcObject properties;

    EventNotification(RpcObject properties) {
        this.properties = properties;
    }

    public Bytes getHash() {
        RpcItem item = this.properties.getItem("hash");
        return item != null ? item.asBytes() : null;
    }

    public BigInteger getHeight() {
        return EventNotification.asInteger(this.properties.getItem("height"));
    }

    public BigInteger getIndex() {
        return EventNotification.asInteger(this.properties.getItem("index"));
    }

    public BigInteger[] getEvents() {
        RpcItem item = this.properties.getItem("events");
        BigInteger[] events = null;
        if (item != null) {
            RpcArray rpcArray = item.asArray();
            int size = rpcArray.size();
            events = new BigInteger[size];
            for (int i = 0; i < size; ++i) {
                events[i] = EventNotification.asInteger(rpcArray.get(i));
            }
        }
        return events;
    }

    public static BigInteger asInteger(RpcItem item) {
        return item != null ? item.asInteger() : null;
    }
}

