/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.monitor;

import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import foundation.icon.icx.transport.monitor.EventMonitorSpec;
import foundation.icon.icx.transport.monitor.MonitorSpec;
import java.math.BigInteger;

public class BlockMonitorSpec
extends MonitorSpec {
    private final BigInteger height;
    private final EventMonitorSpec.EventFilter[] eventFilters;

    public BlockMonitorSpec(BigInteger height, EventMonitorSpec.EventFilter[] eventFilters) {
        this.height = height;
        this.path = "block";
        this.eventFilters = eventFilters;
    }

    @Override
    public RpcObject getParams() {
        RpcObject.Builder builder = new RpcObject.Builder().put("height", new RpcValue(this.height));
        if (this.eventFilters != null) {
            RpcArray.Builder arrBuilder = new RpcArray.Builder();
            for (EventMonitorSpec.EventFilter ef : this.eventFilters) {
                RpcObject.Builder efBuilder = new RpcObject.Builder();
                ef.apply(efBuilder);
                arrBuilder.add(efBuilder.build());
            }
            builder.put("eventFilters", arrBuilder.build());
        }
        return builder.build();
    }
}

