/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx;

import foundation.icon.icx.TransactionBuilder;
import foundation.icon.icx.crypto.IconKeys;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcItemCreator;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.math.BigInteger;

public final class Call<T> {
    private final RpcObject properties;
    private final Class<T> responseType;

    private Call(RpcObject properties, Class<T> responseType) {
        this.properties = properties;
        this.responseType = responseType;
    }

    RpcObject getProperties() {
        return this.properties;
    }

    Class<T> responseType() {
        return this.responseType;
    }

    public static class Builder {
        private Address from;
        private Address to;
        private String method;
        private BigInteger height;
        private RpcItem params;

        public Builder from(Address from) {
            this.from = from;
            return this;
        }

        public Builder to(Address to) {
            if (!IconKeys.isContractAddress(to)) {
                throw new IllegalArgumentException("Only the contract address can be called.");
            }
            this.to = to;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder height(BigInteger height) {
            this.height = height;
            return this;
        }

        public <T> Builder params(T params) {
            this.params = RpcItemCreator.create(params);
            return this;
        }

        public Builder params(RpcItem params) {
            this.params = params;
            return this;
        }

        public Call<RpcItem> build() {
            TransactionBuilder.checkArgument(this.to, "to not found");
            TransactionBuilder.checkArgument(this.method, "method not found");
            return this.buildWith(RpcItem.class);
        }

        public <T> Call<T> buildWith(Class<T> responseType) {
            RpcObject data = new RpcObject.Builder().put("method", new RpcValue(this.method)).put("params", this.params).build();
            RpcObject.Builder propertiesBuilder = new RpcObject.Builder().put("to", new RpcValue(this.to)).put("data", data).put("dataType", new RpcValue("call"));
            if (this.from != null) {
                propertiesBuilder.put("from", new RpcValue(this.from));
            }
            if (this.height != null) {
                propertiesBuilder.put("height", new RpcValue(this.height));
            }
            return new Call(propertiesBuilder.build(), responseType);
        }
    }
}

