/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx;

import foundation.icon.icx.Call;
import foundation.icon.icx.Provider;
import foundation.icon.icx.Request;
import foundation.icon.icx.SignedTransaction;
import foundation.icon.icx.Transaction;
import foundation.icon.icx.crypto.IconKeys;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.BTPNetworkInfo;
import foundation.icon.icx.data.BTPNetworkTypeInfo;
import foundation.icon.icx.data.BTPNotification;
import foundation.icon.icx.data.BTPSourceInfo;
import foundation.icon.icx.data.Base64;
import foundation.icon.icx.data.Block;
import foundation.icon.icx.data.BlockNotification;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.data.ConfirmedTransaction;
import foundation.icon.icx.data.Converters;
import foundation.icon.icx.data.EventNotification;
import foundation.icon.icx.data.ScoreApi;
import foundation.icon.icx.data.ScoreStatus;
import foundation.icon.icx.data.TransactionResult;
import foundation.icon.icx.transport.jsonrpc.AnnotatedConverterFactory;
import foundation.icon.icx.transport.jsonrpc.AnnotationConverter;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcConverter;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import foundation.icon.icx.transport.monitor.BTPMonitorSpec;
import foundation.icon.icx.transport.monitor.BlockMonitorSpec;
import foundation.icon.icx.transport.monitor.EventMonitorSpec;
import foundation.icon.icx.transport.monitor.Monitor;
import foundation.icon.icx.transport.monitor.MonitorSpec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IconService {
    private Provider provider;
    private final List<RpcConverter.RpcConverterFactory> converterFactories = new ArrayList<RpcConverter.RpcConverterFactory>();
    private final Map<Class<?>, RpcConverter<?>> converterMap = new HashMap();

    public IconService(Provider provider) {
        this.provider = provider;
        this.addConverterFactory(Converters.newFactory(BigInteger.class, Converters.BIG_INTEGER));
        this.addConverterFactory(Converters.newFactory(Boolean.class, Converters.BOOLEAN));
        this.addConverterFactory(Converters.newFactory(String.class, Converters.STRING));
        this.addConverterFactory(Converters.newFactory(Bytes.class, Converters.BYTES));
        this.addConverterFactory(Converters.newFactory(byte[].class, Converters.BYTE_ARRAY));
        this.addConverterFactory(Converters.newFactory(Block.class, Converters.BLOCK));
        this.addConverterFactory(Converters.newFactory(ConfirmedTransaction.class, Converters.CONFIRMED_TRANSACTION));
        this.addConverterFactory(Converters.newFactory(TransactionResult.class, Converters.TRANSACTION_RESULT));
        Class<List> listClass = List.class;
        this.addConverterFactory(Converters.newFactory(listClass, Converters.SCORE_API_LIST));
        this.addConverterFactory(Converters.newFactory(RpcItem.class, Converters.RPC_ITEM));
        this.addConverterFactory(Converters.newFactory(BlockNotification.class, Converters.BLOCK_NOTIFICATION));
        this.addConverterFactory(Converters.newFactory(EventNotification.class, Converters.EVENT_NOTIFICATION));
        this.addConverterFactory(Converters.newFactory(BTPNotification.class, Converters.BTP_NOTIFICATION));
        this.addConverterFactory(Converters.newFactory(Base64[].class, Converters.BASE64_ARRAY));
        this.addConverterFactory(Converters.newFactory(Base64[][].class, Converters.BASE64_ARRAY_ARRAY));
        this.addConverterFactory(Converters.newFactory(Base64.class, Converters.BASE64));
        this.addConverterFactory(Converters.newFactory(BTPNetworkInfo.class, Converters.BTP_NETWORK_INFO));
        this.addConverterFactory(Converters.newFactory(BTPNetworkTypeInfo.class, Converters.BTP_NETWORK_TYPE_INFO));
        this.addConverterFactory(Converters.newFactory(BTPSourceInfo.class, Converters.BTP_SOURCE_INFO));
        this.addConverterFactory(Converters.newFactory(ScoreStatus.class, Converters.SCORE_STATUS));
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Request<BigInteger> getTotalSupply() {
        return this.getTotalSupply(null);
    }

    public Request<BigInteger> getTotalSupply(BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = null;
        if (height != null) {
            params = new RpcObject.Builder().put("height", new RpcValue(height)).build();
        }
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getTotalSupply", params);
        return this.provider.request(request, this.findConverter(BigInteger.class));
    }

    public Request<BigInteger> getBalance(Address address) {
        return this.getBalance(address, null);
    }

    public Request<BigInteger> getBalance(Address address, BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject.Builder builder = new RpcObject.Builder().put("address", new RpcValue(address));
        if (height != null) {
            builder.put("height", new RpcValue(height));
        }
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getBalance", builder.build());
        return this.provider.request(request, this.findConverter(BigInteger.class));
    }

    public Request<Block> getBlock(BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("height", new RpcValue(height)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getBlockByHeight", params);
        return this.provider.request(request, this.findConverter(Block.class));
    }

    public Request<Block> getBlock(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("hash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getBlockByHash", params);
        return this.provider.request(request, this.findConverter(Block.class));
    }

    public Request<Block> getLastBlock() {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getLastBlock", null);
        return this.provider.request(request, this.findConverter(Block.class));
    }

    public Request<List<ScoreApi>> getScoreApi(Address scoreAddress) {
        return this.getScoreApi(scoreAddress, null);
    }

    public Request<List<ScoreApi>> getScoreApi(Address scoreAddress, BigInteger height) {
        if (!IconKeys.isContractAddress(scoreAddress)) {
            throw new IllegalArgumentException("Only the contract address can be called.");
        }
        long requestId = System.currentTimeMillis();
        RpcObject.Builder builder = new RpcObject.Builder().put("address", new RpcValue(scoreAddress));
        if (height != null) {
            builder.put("height", new RpcValue(height));
        }
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getScoreApi", builder.build());
        Class<List> listClass = List.class;
        return this.provider.request(request, this.findConverter(listClass));
    }

    public Request<ConfirmedTransaction> getTransaction(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("txHash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getTransactionByHash", params);
        return this.provider.request(request, this.findConverter(ConfirmedTransaction.class));
    }

    public Request<TransactionResult> getTransactionResult(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("txHash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getTransactionResult", params);
        return this.provider.request(request, this.findConverter(TransactionResult.class));
    }

    public <T> Request<T> call(Call<T> call) {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_call", call.getProperties());
        return this.provider.request(request, this.findConverter(call.responseType()));
    }

    public Request<Bytes> sendTransaction(SignedTransaction signedTransaction) {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_sendTransaction", signedTransaction.getProperties());
        return this.provider.request(request, this.findConverter(Bytes.class));
    }

    public Request<BigInteger> estimateStep(Transaction transaction) {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "debug_estimateStep", transaction.getProperties());
        return this.provider.request(request, this.findConverter(BigInteger.class));
    }

    public Request<TransactionResult> sendTransactionAndWait(SignedTransaction signedTransaction) {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_sendTransactionAndWait", signedTransaction.getProperties());
        return this.provider.request(request, this.findConverter(TransactionResult.class));
    }

    public Request<TransactionResult> waitTransactionResult(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("txHash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_waitTransactionResult", params);
        return this.provider.request(request, this.findConverter(TransactionResult.class));
    }

    public Request<Base64> getDataByHash(Bytes hash) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("hash", new RpcValue(hash)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getDataByHash", params);
        return this.provider.request(request, this.findConverter(Base64.class));
    }

    public Request<Base64> getBlockHeaderByHeight(BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("height", new RpcValue(height)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getBlockHeaderByHeight", params);
        return this.provider.request(request, this.findConverter(Base64.class));
    }

    public Request<Base64> getVotesByHeight(BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("height", new RpcValue(height)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getVotesByHeight", params);
        return this.provider.request(request, this.findConverter(Base64.class));
    }

    public Request<Base64[]> getProofForResult(Bytes hash, BigInteger index) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("hash", new RpcValue(hash)).put("index", new RpcValue(index)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getProofForResult", params);
        return this.provider.request(request, this.findConverter(Base64[].class));
    }

    public Request<Base64[][]> getProofForEvents(Bytes hash, BigInteger index, BigInteger[] events) {
        long requestId = System.currentTimeMillis();
        RpcArray.Builder arrayBuilder = new RpcArray.Builder();
        for (BigInteger d : events) {
            arrayBuilder.add(new RpcValue(d));
        }
        RpcObject params = new RpcObject.Builder().put("hash", new RpcValue(hash)).put("index", new RpcValue(index)).put("events", arrayBuilder.build()).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getProofForEvents", params);
        return this.provider.request(request, this.findConverter(Base64[][].class));
    }

    public Request<ScoreStatus> getScoreStatus(Address contract) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("address", new RpcValue(contract)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "icx_getScoreStatus", params);
        return this.provider.request(request, this.findConverter(ScoreStatus.class));
    }

    public Monitor<BlockNotification> monitorBlocks(BigInteger height) {
        return this.monitor(new BlockMonitorSpec(height, null));
    }

    public Monitor<BlockNotification> monitorBlocks(BigInteger height, EventMonitorSpec.EventFilter[] eventFilters) {
        return this.monitor(new BlockMonitorSpec(height, eventFilters));
    }

    public Monitor<EventNotification> monitorEvents(BigInteger height, String event, Address addr, String[] indexed, String[] data) {
        return this.monitor(new EventMonitorSpec(height, event, addr, indexed, data));
    }

    public Monitor<BTPNotification> monitorBTP(BigInteger height, BigInteger networkId, boolean proofFlag) {
        return this.monitor(new BTPMonitorSpec(height, networkId, proofFlag));
    }

    public <T> Monitor<T> monitor(MonitorSpec<T> ms) {
        return this.provider.monitor(ms, this.findConverter(ms.getNotificationClass()));
    }

    public Request<BTPNetworkInfo> getBTPNetworkInfo(BigInteger id) {
        return this.getBTPNetworkInfo(id, null);
    }

    public Request<BTPNetworkInfo> getBTPNetworkInfo(BigInteger id, BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject.Builder params = new RpcObject.Builder().put("id", new RpcValue(id));
        if (height != null) {
            params.put("height", new RpcValue(height));
        }
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "btp_getNetworkInfo", params.build());
        return this.provider.request(request, this.findConverter(BTPNetworkInfo.class));
    }

    public Request<BTPNetworkTypeInfo> getBTPNetworkTypeInfo(BigInteger id) {
        return this.getBTPNetworkTypeInfo(id, null);
    }

    public Request<BTPNetworkTypeInfo> getBTPNetworkTypeInfo(BigInteger id, BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject.Builder params = new RpcObject.Builder().put("id", new RpcValue(id));
        if (height != null) {
            params.put("height", new RpcValue(height));
        }
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "btp_getNetworkTypeInfo", params.build());
        return this.provider.request(request, this.findConverter(BTPNetworkTypeInfo.class));
    }

    public Request<Base64[]> getBTPMessages(BigInteger networkID, BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("height", new RpcValue(height)).put("networkID", new RpcValue(networkID)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "btp_getMessages", params);
        return this.provider.request(request, this.findConverter(Base64[].class));
    }

    public Request<Base64> getBTPHeader(BigInteger networkID, BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("height", new RpcValue(height)).put("networkID", new RpcValue(networkID)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "btp_getHeader", params);
        return this.provider.request(request, this.findConverter(Base64.class));
    }

    public Request<Base64> getBTPProof(BigInteger networkID, BigInteger height) {
        long requestId = System.currentTimeMillis();
        RpcObject params = new RpcObject.Builder().put("height", new RpcValue(height)).put("networkID", new RpcValue(networkID)).build();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "btp_getProof", params);
        return this.provider.request(request, this.findConverter(Base64.class));
    }

    public Request<BTPSourceInfo> getBTPSourceInformation() {
        long requestId = System.currentTimeMillis();
        foundation.icon.icx.transport.jsonrpc.Request request = new foundation.icon.icx.transport.jsonrpc.Request(requestId, "btp_getSourceInformation", null);
        return this.provider.request(request, this.findConverter(BTPSourceInfo.class));
    }

    private <T> RpcConverter<T> findConverter(Class<T> type) {
        RpcConverter<Object> converter = this.converterMap.get(type);
        if (converter != null) {
            return converter;
        }
        for (RpcConverter.RpcConverterFactory factory : this.converterFactories) {
            converter = factory.create(type);
            if (converter == null) continue;
            this.converterMap.put(type, converter);
            return converter;
        }
        if (type.isAnnotationPresent(AnnotationConverter.class) && type.getAnnotation(AnnotationConverter.class).use()) {
            return new AnnotatedConverterFactory().create(type);
        }
        throw new IllegalArgumentException("Could not locate response converter for:'" + type + "'");
    }

    public void addConverterFactory(RpcConverter.RpcConverterFactory factory) {
        this.converterFactories.add(factory);
    }
}

