/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx;

import foundation.icon.icx.TransactionBuilder;
import foundation.icon.icx.Wallet;
import foundation.icon.icx.crypto.ECDSASignature;
import foundation.icon.icx.crypto.IconKeys;
import foundation.icon.icx.crypto.KeyStoreUtils;
import foundation.icon.icx.crypto.Keystore;
import foundation.icon.icx.crypto.KeystoreException;
import foundation.icon.icx.crypto.KeystoreFile;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class KeyWallet
implements Wallet {
    private final Bytes privateKey;
    private final Bytes publicKey;

    private KeyWallet(Bytes privateKey, Bytes publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public static KeyWallet load(Bytes privateKey) {
        Bytes publicKey = IconKeys.getPublicKey(privateKey);
        return new KeyWallet(privateKey, publicKey);
    }

    public static KeyWallet create() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        Bytes privateKey = IconKeys.createPrivateKey();
        Bytes publicKey = IconKeys.getPublicKey(privateKey);
        return new KeyWallet(privateKey, publicKey);
    }

    public static KeyWallet load(String password, File file) throws IOException, KeystoreException {
        Bytes privateKey = KeyStoreUtils.loadPrivateKey(password, file);
        Bytes pubicKey = IconKeys.getPublicKey(privateKey);
        return new KeyWallet(privateKey, pubicKey);
    }

    public static String store(KeyWallet wallet, String password, File destinationDirectory) throws KeystoreException, IOException {
        KeystoreFile keystoreFile = Keystore.create(password, wallet.getPrivateKey(), 16384, 1);
        return KeyStoreUtils.generateWalletFile(keystoreFile, destinationDirectory);
    }

    @Override
    public Address getAddress() {
        return IconKeys.getAddress(this.publicKey);
    }

    @Override
    public byte[] sign(byte[] data) {
        TransactionBuilder.checkArgument(data, "hash not found");
        ECDSASignature signature = new ECDSASignature(this.privateKey);
        BigInteger[] sig = signature.generateSignature(data);
        return signature.recoverableSerialize(sig, data);
    }

    public Bytes getPrivateKey() {
        return this.privateKey;
    }

    public Bytes getPublicKey() {
        return this.publicKey;
    }

    public Bytes getPublicKey(boolean compressed) {
        return IconKeys.getPublicKey(this.privateKey, compressed);
    }
}

