/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.crypto;

import foundation.icon.icx.crypto.IconKeys;
import foundation.icon.icx.data.Bytes;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.bouncycastle.util.BigIntegers;

public class ECDSASignature {
    private final X9ECParameters curveParams = CustomNamedCurves.getByName((String)"secp256k1");
    private final ECDomainParameters curve = new ECDomainParameters(this.curveParams.getCurve(), this.curveParams.getG(), this.curveParams.getN(), this.curveParams.getH());
    private final Bytes privateKey;

    public ECDSASignature(Bytes privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] recoverableSerialize(BigInteger[] sig, byte[] message) {
        byte recId = this.findRecoveryId(sig, message);
        ByteBuffer buffer = ByteBuffer.allocate(65);
        buffer.put(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)sig[0]));
        buffer.put(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)sig[1]));
        buffer.put(recId);
        return buffer.array();
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger p = new BigInteger(1, this.privateKey.toByteArray());
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters param = new ECPrivateKeyParameters(p, this.curve);
        signer.init(true, (CipherParameters)param);
        BigInteger[] sig = signer.generateSignature(message);
        BigInteger r = sig[0];
        BigInteger s = sig[1];
        if (s.compareTo(this.curveParams.getN().shiftRight(1)) > 0) {
            s = this.curve.getN().subtract(s);
        }
        return new BigInteger[]{r, s};
    }

    public byte findRecoveryId(BigInteger[] sig, byte[] message) {
        Bytes publicKey = IconKeys.getPublicKey(this.privateKey);
        BigInteger p = new BigInteger(1, publicKey.toByteArray());
        int recId = -1;
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            BigInteger k = this.recoverFromSignature(i, sig, message);
            if (k == null || !k.equals(p)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        return (byte)recId;
    }

    private BigInteger recoverFromSignature(int recId, BigInteger[] sig, byte[] message) {
        BigInteger r = sig[0];
        BigInteger s = sig[1];
        this.checkArgument(recId >= 0, "recId must be positive");
        this.checkArgument(r.signum() >= 0, "r must be positive");
        this.checkArgument(s.signum() >= 0, "s must be positive");
        this.checkArgument(message != null, "message cannot be null");
        BigInteger n = this.curve.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = r.add(i.multiply(n));
        BigInteger prime = SecP256K1Curve.q;
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        ECPoint ecPoint = this.decompressKey(x, (recId & 1) == 1);
        if (!ecPoint.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)this.curve.getG(), (BigInteger)eInvrInv, (ECPoint)ecPoint, (BigInteger)srInv);
        return new BigInteger(1, q.getEncoded(false));
    }

    private ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(this.curve.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return this.curve.getCurve().decodePoint(compEnc);
    }

    private void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }
}

