/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.crypto;

import foundation.icon.icx.crypto.LinuxSecureRandom;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.digest.SHA3;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class IconKeys {
    public static final int PRIVATE_KEY_SIZE = 32;
    public static final int PUBLIC_KEY_SIZE = 65;
    public static final int PUBLIC_KEY_SIZE_COMP = 33;
    public static final int ADDRESS_SIZE = 160;
    public static final int ADDRESS_LENGTH_IN_HEX = 40;
    private static final SecureRandom SECURE_RANDOM;
    private static int isAndroid;
    public static final double MIN_BOUNCY_CASTLE_VERSION = 1.46;

    private IconKeys() {
    }

    public static Bytes createPrivateKey() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256k1");
        keyPairGenerator.initialize(ecGenParameterSpec, IconKeys.secureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        BigInteger d = ((BCECPrivateKey)keyPair.getPrivate()).getD();
        return new Bytes(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)d));
    }

    public static Bytes getPublicKey(Bytes privateKey) {
        return IconKeys.getPublicKey(privateKey, false);
    }

    public static Bytes getPublicKey(Bytes privateKey, boolean compressed) {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECPoint pointQ = spec.getG().multiply(new BigInteger(1, privateKey.toByteArray()));
        return new Bytes(pointQ.getEncoded(compressed));
    }

    private static byte[] convertPublicKey(byte[] pubKey, boolean toCompressed) {
        int resultLen;
        int inputLen = pubKey != null ? pubKey.length : -1;
        int expectInputLen = toCompressed ? 65 : 33;
        int n = resultLen = toCompressed ? 33 : 65;
        if (inputLen == resultLen) {
            return pubKey;
        }
        if (inputLen != expectInputLen) {
            throw new IllegalArgumentException("The length of Bytes must be 65 or 33");
        }
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECPoint point = spec.getCurve().decodePoint(pubKey);
        return point.getEncoded(toCompressed);
    }

    public static Address getAddress(Bytes publicKey) {
        return new Address(Address.AddressPrefix.EOA, IconKeys.getAddressHash(publicKey.toByteArray()));
    }

    public static byte[] getAddressHash(BigInteger publicKey) {
        if (publicKey.signum() < 0) {
            throw new IllegalArgumentException("The publicKey cannot be negative");
        }
        return IconKeys.getAddressHash(BigIntegers.asUnsignedByteArray((int)65, (BigInteger)publicKey));
    }

    public static byte[] getAddressHash(byte[] publicKey) {
        byte[] pubKey = IconKeys.convertPublicKey(publicKey, false);
        byte[] pub = Arrays.copyOfRange(pubKey, 1, pubKey.length);
        byte[] hash = new SHA3.Digest256().digest(pub);
        int length = 20;
        byte[] result = new byte[20];
        System.arraycopy(hash, hash.length - 20, result, 0, length);
        return result;
    }

    public static boolean isValidAddress(Address input) {
        return IconKeys.isValidAddress(input.toString());
    }

    public static boolean isValidAddress(String input) {
        String cleanInput = IconKeys.cleanHexPrefix(input);
        try {
            return cleanInput.matches("^[0-9a-f]{40}$") && cleanInput.length() == 40;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidAddressBody(byte[] body) {
        return body.length == 20 && IconKeys.isValidAddress(Hex.toHexString((byte[])body));
    }

    public static boolean isContractAddress(Address address) {
        return address.getPrefix() == Address.AddressPrefix.CONTRACT;
    }

    public static String cleanHexPrefix(String input) {
        if (IconKeys.containsHexPrefix(input)) {
            return input.substring(2);
        }
        return input;
    }

    public static boolean containsHexPrefix(String input) {
        return IconKeys.getAddressHexPrefix(input) != null;
    }

    public static Address.AddressPrefix getAddressHexPrefix(String input) {
        return Address.AddressPrefix.fromString(input.substring(0, 2));
    }

    public static SecureRandom secureRandom() {
        return SECURE_RANDOM;
    }

    public static boolean isAndroidRuntime() {
        if (isAndroid == -1) {
            String runtime = System.getProperty("java.runtime.name");
            isAndroid = runtime != null && runtime.equals("Android Runtime") ? 1 : 0;
        }
        return isAndroid == 1;
    }

    static {
        isAndroid = -1;
        if (IconKeys.isAndroidRuntime()) {
            new LinuxSecureRandom();
        }
        Provider provider = Security.getProvider("BC");
        BouncyCastleProvider newProvider = new BouncyCastleProvider();
        if (newProvider.getVersion() < 1.46) {
            String message = String.format("The version of BouncyCastle should be %f or newer", 1.46);
            throw new RuntimeCryptoException(message);
        }
        if (provider != null) {
            Security.removeProvider("BC");
        }
        Security.addProvider((Provider)newProvider);
        SECURE_RANDOM = new SecureRandom();
    }
}

