/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.crypto.IconKeys;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class Address {
    private AddressPrefix prefix;
    private byte[] body;
    private boolean isMalformed = false;
    private String malformedAddress;

    public static Address createMalformedAddress(String malformedAddress) {
        Address address = new Address();
        address.isMalformed = true;
        address.malformedAddress = malformedAddress;
        return address;
    }

    private Address() {
    }

    public Address(String address) {
        AddressPrefix addressPrefix = IconKeys.getAddressHexPrefix(address);
        if (addressPrefix == null) {
            throw new IllegalArgumentException("Invalid address prefix");
        }
        if (!IconKeys.isValidAddress(address)) {
            throw new IllegalArgumentException("Invalid address");
        }
        this.prefix = addressPrefix;
        this.body = this.getAddressBody(address);
    }

    public Address(AddressPrefix prefix, byte[] body) {
        if (!IconKeys.isValidAddressBody(body)) {
            throw new IllegalArgumentException("Invalid address");
        }
        this.prefix = prefix;
        this.body = body;
    }

    private byte[] getAddressBody(String address) {
        String cleanInput = IconKeys.cleanHexPrefix(address);
        return Hex.decode((String)cleanInput);
    }

    public AddressPrefix getPrefix() {
        return this.prefix;
    }

    public byte[] getBody() {
        return (byte[])this.body.clone();
    }

    public boolean isMalformed() {
        return this.isMalformed;
    }

    public String toString() {
        if (this.isMalformed) {
            return this.malformedAddress;
        }
        return this.getPrefix().getValue() + Hex.toHexString((byte[])this.body);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Address) {
            Address other = (Address)obj;
            if (this.isMalformed) {
                return this.malformedAddress.equals(other.malformedAddress);
            }
            return !other.isMalformed && other.prefix == this.prefix && Arrays.equals(other.body, this.body);
        }
        return false;
    }

    public int hashCode() {
        if (this.isMalformed) {
            return this.malformedAddress.hashCode();
        }
        byte[] raw = new byte[this.body.length + 1];
        raw[0] = (byte)this.prefix.ordinal();
        System.arraycopy(this.body, 0, raw, 1, this.body.length);
        return Arrays.hashCode(raw);
    }

    public static enum AddressPrefix {
        EOA("hx"),
        CONTRACT("cx");

        private final String prefix;

        private AddressPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getValue() {
            return this.prefix;
        }

        public static AddressPrefix fromString(String prefix) {
            if (prefix != null) {
                for (AddressPrefix p : AddressPrefix.values()) {
                    if (!prefix.equalsIgnoreCase(p.getValue())) continue;
                    return p;
                }
            }
            return null;
        }
    }
}

