/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;

public class BTPNetworkInfo {
    private final RpcObject properties;

    public BTPNetworkInfo(RpcObject properties) {
        this.properties = properties;
    }

    public RpcObject getProperties() {
        return this.properties;
    }

    public BigInteger getStartHeight() {
        RpcItem item = this.properties.getItem("startHeight");
        return item != null ? item.asInteger() : null;
    }

    public BigInteger getNetworkTypeID() {
        RpcItem item = this.properties.getItem("networkTypeID");
        return item != null ? item.asInteger() : null;
    }

    public String getNetworkTypeName() {
        RpcItem item = this.properties.getItem("networkTypeName");
        return item != null ? item.asString() : null;
    }

    public BigInteger getNetworkID() {
        RpcItem item = this.properties.getItem("networkID");
        return item != null ? item.asInteger() : null;
    }

    public String getNetworkName() {
        RpcItem item = this.properties.getItem("networkName");
        return item != null ? item.asString() : null;
    }

    public Boolean getOpen() {
        RpcItem item = this.properties.getItem("open");
        return item != null ? item.asBoolean() : null;
    }

    public Address getOwner() {
        RpcItem item = this.properties.getItem("owner");
        return item != null ? item.asAddress() : null;
    }

    public BigInteger getNextMessageSN() {
        RpcItem item = this.properties.getItem("nextMessageSN");
        return item != null ? item.asInteger() : null;
    }

    public Boolean getNextProofContextChanged() {
        RpcItem item = this.properties.getItem("nextProofContextChanged");
        return item != null ? item.asBoolean() : null;
    }

    public Bytes getPrevNSHash() {
        RpcItem item = this.properties.getItem("prevNSHash");
        if (item == null || item.isEmpty()) {
            return null;
        }
        return item.asBytes();
    }

    public Bytes getLastNSHash() {
        RpcItem item = this.properties.getItem("lastNSHash");
        return item != null ? item.asBytes() : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BTPNetworkInfo)) {
            return false;
        }
        BTPNetworkInfo o = (BTPNetworkInfo)obj;
        return this.properties.equals(o.properties);
    }

    public String toString() {
        return "BTPNetworkInfo{properties=" + this.properties + '}';
    }
}

