/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Converters;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BTPNetworkTypeInfo {
    private final RpcObject properties;

    BTPNetworkTypeInfo(RpcObject properties) {
        this.properties = properties;
    }

    public RpcObject getProperties() {
        return this.properties;
    }

    public BigInteger getNetworkTypeID() {
        RpcItem item = this.properties.getItem("networkTypeID");
        return item != null ? item.asInteger() : null;
    }

    public String getNetworkTypeName() {
        RpcItem item = this.properties.getItem("networkTypeName");
        return item != null ? item.asString() : null;
    }

    public List<BigInteger> getOpenNetworkIDs() {
        RpcItem item = this.properties.getItem("openNetworkIDs");
        ArrayList<BigInteger> ids = new ArrayList<BigInteger>();
        if (item != null) {
            for (RpcItem rpcItem : item.asArray()) {
                ids.add(Converters.BIG_INTEGER.convertTo(rpcItem));
            }
        }
        return ids;
    }

    public String getNextProofContext() {
        RpcItem item = this.properties.getItem("nextProofContext");
        return item != null ? item.asString() : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BTPNetworkTypeInfo)) {
            return false;
        }
        BTPNetworkTypeInfo ntInfo = (BTPNetworkTypeInfo)obj;
        return this.properties.equals(ntInfo.properties);
    }

    public String toString() {
        return "BTPNetworkTypeInfo{properties=" + this.properties + '}';
    }
}

