/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.Transaction;
import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.math.BigInteger;

public class ConfirmedTransaction
implements Transaction {
    private final RpcObject properties;

    ConfirmedTransaction(RpcObject properties) {
        this.properties = properties;
    }

    @Override
    public RpcObject getProperties() {
        return this.properties;
    }

    @Override
    public BigInteger getVersion() {
        RpcItem item = this.properties.getItem("version");
        return item != null ? item.asInteger() : BigInteger.valueOf(2L);
    }

    @Override
    public Address getFrom() {
        RpcItem item = this.properties.getItem("from");
        return item != null ? item.asAddress() : null;
    }

    @Override
    public Address getTo() {
        RpcItem item = this.properties.getItem("to");
        return item != null ? item.asAddress() : null;
    }

    public BigInteger getFee() {
        RpcItem item = this.properties.getItem("fee");
        return item != null ? this.convertHex(item.asValue()) : null;
    }

    @Override
    public BigInteger getValue() {
        RpcItem item = this.properties.getItem("value");
        if (item == null) {
            return null;
        }
        return this.getVersion().intValue() < 3 ? this.convertHex(item.asValue()) : item.asInteger();
    }

    @Override
    public BigInteger getStepLimit() {
        RpcItem item = this.properties.getItem("stepLimit");
        return item != null ? item.asInteger() : null;
    }

    @Override
    public BigInteger getTimestamp() {
        RpcItem item = this.properties.getItem("timestamp");
        if (item == null) {
            return null;
        }
        return this.getVersion().intValue() < 3 ? this.convertDecimal(item.asValue()) : item.asInteger();
    }

    @Override
    public BigInteger getNid() {
        RpcItem item = this.properties.getItem("nid");
        return item != null ? item.asInteger() : null;
    }

    @Override
    public BigInteger getNonce() {
        RpcItem item = this.properties.getItem("nonce");
        if (item == null) {
            return null;
        }
        return this.getVersion().intValue() < 3 ? this.convertDecimal(item.asValue()) : item.asInteger();
    }

    @Override
    public String getDataType() {
        RpcItem item = this.properties.getItem("dataType");
        return item != null ? item.asString() : null;
    }

    @Override
    public RpcItem getData() {
        return this.properties.getItem("data");
    }

    public Bytes getTxHash() {
        String key = this.getVersion().intValue() < 3 ? "tx_hash" : "txHash";
        RpcItem item = this.properties.getItem(key);
        return item != null ? item.asBytes() : null;
    }

    public BigInteger getTxIndex() {
        RpcItem item = this.properties.getItem("txIndex");
        return item != null ? item.asInteger() : null;
    }

    public BigInteger getBlockHeight() {
        RpcItem item = this.properties.getItem("blockHeight");
        return item != null ? item.asInteger() : null;
    }

    public Bytes getBlockHash() {
        RpcItem item = this.properties.getItem("blockHash");
        return item != null ? item.asBytes() : null;
    }

    public String getSignature() {
        RpcItem item = this.properties.getItem("signature");
        return item != null ? item.asString() : null;
    }

    public String toString() {
        return "ConfirmedTransaction{properties=" + this.properties + '}';
    }

    private BigInteger convertDecimal(RpcValue value) {
        if (value.isEmpty()) {
            return null;
        }
        String stringValue = value.asString();
        if (stringValue.startsWith("0x") || stringValue.startsWith("-0x")) {
            return this.convertHex(value);
        }
        return new BigInteger(stringValue, 10);
    }

    private BigInteger convertHex(RpcValue value) {
        String stringValue = value.asString();
        String sign = "";
        if (stringValue.charAt(0) == '-') {
            sign = stringValue.substring(0, 1);
            stringValue = stringValue.substring(1);
        }
        return new BigInteger(sign + Bytes.cleanHexPrefix(stringValue), 16);
    }
}

