/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import java.math.BigDecimal;
import java.math.BigInteger;

public class IconAmount {
    private final BigDecimal value;
    private final int digit;

    public IconAmount(BigDecimal value, int digit) {
        this.value = value;
        this.digit = digit;
    }

    public int getDigit() {
        return this.digit;
    }

    public String toString() {
        return this.value.toString();
    }

    public BigInteger asInteger() {
        return this.value.toBigInteger();
    }

    public BigDecimal asDecimal() {
        return this.value;
    }

    public BigInteger toLoop() {
        return this.value.multiply(this.getTenDigit(this.digit)).toBigInteger();
    }

    public IconAmount convertUnit(Unit unit) {
        BigInteger loop = this.toLoop();
        return IconAmount.of(new BigDecimal(loop).divide(this.getTenDigit(unit.getValue())), unit);
    }

    public IconAmount convertUnit(int digit) {
        BigInteger loop = this.toLoop();
        return IconAmount.of(new BigDecimal(loop).divide(this.getTenDigit(digit)), digit);
    }

    private BigDecimal getTenDigit(int digit) {
        return BigDecimal.TEN.pow(digit);
    }

    public static IconAmount of(BigDecimal loop, int digit) {
        return new IconAmount(loop, digit);
    }

    public static IconAmount of(BigDecimal loop, Unit unit) {
        return IconAmount.of(loop, unit.getValue());
    }

    public static IconAmount of(String loop, int digit) {
        return IconAmount.of(new BigDecimal(loop), digit);
    }

    public static IconAmount of(String loop, Unit unit) {
        return IconAmount.of(new BigDecimal(loop), unit.getValue());
    }

    public static IconAmount of(BigInteger loop, int digit) {
        return IconAmount.of(new BigDecimal(loop), digit);
    }

    public static IconAmount of(BigInteger loop, Unit unit) {
        return IconAmount.of(new BigDecimal(loop), unit.getValue());
    }

    public static enum Unit {
        LOOP(0),
        ICX(18);

        int digit;

        private Unit(int digit) {
            this.digit = digit;
        }

        public int getValue() {
            return this.digit;
        }
    }
}

