/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ScoreApi {
    private final RpcObject properties;

    ScoreApi(RpcObject properties) {
        this.properties = properties;
    }

    public RpcObject getProperties() {
        return this.properties;
    }

    public String getType() {
        RpcItem item = this.properties.getItem("type");
        return item != null ? item.asString() : null;
    }

    public String getName() {
        RpcItem item = this.properties.getItem("name");
        return item != null ? item.asString() : null;
    }

    public List<Param> getInputs() {
        return this.getParams(this.properties.getItem("inputs"));
    }

    public List<Param> getOutputs() {
        return this.getParams(this.properties.getItem("outputs"));
    }

    List<Param> getParams(RpcItem item) {
        ArrayList<Param> params = new ArrayList<Param>();
        if (item != null) {
            for (RpcItem rpcItem : item.asArray()) {
                RpcObject object = (RpcObject)rpcItem;
                params.add(new Param(object));
            }
        }
        return params;
    }

    public String getReadonly() {
        RpcItem item = this.properties.getItem("readonly");
        return item != null ? item.asString() : null;
    }

    public String toString() {
        return "ScoreApi{properties=" + this.properties + '}';
    }

    public static class Param {
        private final RpcObject properties;

        Param(RpcObject properties) {
            this.properties = properties;
        }

        public String getType() {
            RpcItem item = this.properties.getItem("type");
            return item != null ? item.asString() : null;
        }

        public String getName() {
            RpcItem item = this.properties.getItem("name");
            return item != null ? item.asString() : null;
        }

        public BigInteger getIndexed() {
            RpcItem item = this.properties.getItem("indexed");
            return item != null ? item.asInteger() : null;
        }

        public RpcItem getDefault() {
            return this.properties.getItem("default");
        }

        public String toString() {
            return "Param{properties=" + this.properties + '}';
        }
    }
}

