/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.data;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import java.math.BigInteger;

public class ScoreStatus {
    private final RpcObject properties;

    ScoreStatus(RpcObject properties) {
        this.properties = properties;
    }

    public RpcObject getProperties() {
        return this.properties;
    }

    public Address getOwner() {
        RpcItem item = this.properties.getItem("owner");
        return item != null ? item.asAddress() : null;
    }

    public ContractStatus getCurrent() {
        RpcItem item = this.properties.getItem("current");
        return item != null ? new ContractStatus(item.asObject()) : null;
    }

    public ContractStatus getNext() {
        RpcItem item = this.properties.getItem("next");
        return item != null ? new ContractStatus(item.asObject()) : null;
    }

    public DepositInfo getDepositInfo() {
        RpcItem item = this.properties.getItem("depositInfo");
        return item != null ? new DepositInfo(item.asObject()) : null;
    }

    public boolean isDisabled() {
        RpcItem value = this.properties.getItem("disabled");
        return value != null && value.asBoolean() != false;
    }

    public boolean isBlocked() {
        RpcItem value = this.properties.getItem("blocked");
        return value != null && value.asBoolean() != false;
    }

    public boolean useSystemDeposit() {
        RpcItem value = this.properties.getItem("useSystemDeposit");
        return value != null && value.asBoolean() != false;
    }

    public String toString() {
        return "ScoreStatus{properties=" + this.properties + '}';
    }

    public static class DepositInfo {
        private final RpcObject properties;
        private final RpcArray deposits;

        DepositInfo(RpcObject properties) {
            this.properties = properties;
            this.deposits = properties.getItem("deposits").asArray();
        }

        public String toString() {
            return "DepositInfo{properties=" + this.properties + "}";
        }

        public BigInteger getAvailableDeposit() {
            RpcItem item = this.properties.getItem("availableDeposit");
            return item.asInteger();
        }

        public BigInteger getAvailableVirtualStep() {
            RpcItem item = this.properties.getItem("availableVirtualStep");
            return item.asInteger();
        }

        public RpcObject getDeposit(int idx) {
            return this.deposits.get(idx).asObject();
        }

        public int getSizeOfDeposits() {
            return this.deposits.size();
        }
    }

    public static class ContractStatus {
        private final RpcObject properties;

        ContractStatus(RpcObject properties) {
            this.properties = properties;
        }

        public Bytes getDeployTxHash() {
            RpcItem item = this.properties.getItem("deployTxHash");
            return item != null ? item.asBytes() : null;
        }

        public Bytes getAuditTxHash() {
            RpcItem item = this.properties.getItem("auditTxHash");
            return item != null ? item.asBytes() : null;
        }

        public Bytes getCodeHash() {
            RpcItem code_hash = this.properties.getItem("codeHash");
            return code_hash.asBytes();
        }

        public String getType() {
            RpcItem item = this.properties.getItem("type");
            return item.asString();
        }

        public String getStatus() {
            RpcItem item = this.properties.getItem("status");
            return item.asString();
        }

        public String toString() {
            return "Contract{properties=" + this.properties + "}";
        }
    }
}

