/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import foundation.icon.icx.Provider;
import foundation.icon.icx.Request;
import foundation.icon.icx.transport.http.HttpCall;
import foundation.icon.icx.transport.jsonrpc.RpcConverter;
import foundation.icon.icx.transport.jsonrpc.RpcError;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcItemDeserializer;
import foundation.icon.icx.transport.jsonrpc.RpcItemSerializer;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.monitor.Monitor;
import foundation.icon.icx.transport.monitor.MonitorSpec;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.BufferedSink;

public class HttpProvider
implements Provider {
    private final OkHttpClient httpClient;
    private String serverUri;
    private String channel;
    private final int version;
    private HashMap<String, String> urlMap;

    public HttpProvider(OkHttpClient httpClient, String url) {
        this(httpClient, true, url, 3);
    }

    public HttpProvider(OkHttpClient httpClient, String uri, int version) {
        this(httpClient, false, uri, version);
    }

    public HttpProvider(String url) {
        this(new OkHttpClient.Builder().build(), url);
    }

    public HttpProvider(String uri, int version) {
        this(new OkHttpClient.Builder().build(), uri, version);
    }

    private HttpProvider(OkHttpClient httpClient, boolean allowPath, String uri, int version) {
        this.httpClient = httpClient;
        if (version != 3) {
            throw new IllegalArgumentException("Unsupported version");
        }
        this.version = version;
        new Parser(uri).parse(allowPath);
        this.generateUrlMap();
    }

    @Override
    public <T> Request<T> request(final foundation.icon.icx.transport.jsonrpc.Request request, RpcConverter<T> converter) {
        RequestBody body = new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"application/json");
            }

            public void writeTo(BufferedSink sink) throws IOException {
                ObjectMapper mapper = new ObjectMapper();
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                SimpleModule module = new SimpleModule();
                module.addSerializer(RpcItem.class, (JsonSerializer)new RpcItemSerializer());
                mapper.registerModule((Module)module);
                mapper.writeValue(sink.outputStream(), (Object)request);
            }
        };
        String method = request.getMethod();
        String prefix = method.substring(0, method.indexOf("_"));
        String url = this.urlMap.get(prefix);
        okhttp3.Request httpRequest = new Request.Builder().url(url).post(body).build();
        return new HttpCall<T>(this.httpClient.newCall(httpRequest), converter);
    }

    private void generateUrlMap() {
        this.urlMap = new HashMap();
        this.urlMap.put("icx", this.serverUri + "/api/v" + this.version + "/" + this.channel);
        this.urlMap.put("btp", this.serverUri + "/api/v" + this.version + "/" + this.channel);
        this.urlMap.put("debug", this.serverUri + "/api/v" + this.version + "d/" + this.channel);
    }

    @Override
    public <T> Monitor<T> monitor(MonitorSpec spec, RpcConverter<T> converter) {
        return new HttpMonitor<T>(spec, converter);
    }

    private class HttpMonitor<T>
    implements Monitor<T> {
        Monitor.Listener<T> listener;
        MonitorSpec spec;
        WsState state = WsState.WS_INIT;
        WebSocket ws;
        final Object condVar = new Object();
        RpcConverter<T> rpcConverter;
        ObjectMapper mapper;

        HttpMonitor(MonitorSpec spec, RpcConverter<T> converter) {
            this.spec = spec;
            this.rpcConverter = converter;
            this.mapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addDeserializer(RpcItem.class, (JsonDeserializer)new RpcItemDeserializer());
            this.mapper.registerModule((Module)module);
        }

        private WebSocket newWebSocket(String request) {
            String url = (String)HttpProvider.this.urlMap.get("icx");
            okhttp3.Request httpRequest = new Request.Builder().url(url + "/" + this.spec.getPath()).build();
            return HttpProvider.this.httpClient.newWebSocket(httpRequest, (WebSocketListener)new WebSocketListenerImpl(request));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean start(Monitor.Listener<T> listener) {
            String request;
            Object object = this.condVar;
            synchronized (object) {
                switch (this.state) {
                    case WS_INIT: 
                    case WS_STOP: {
                        this.state = WsState.WS_REQUEST;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            this.listener = listener;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            SimpleModule module = new SimpleModule();
            module.addSerializer(RpcItem.class, (JsonSerializer)new RpcItemSerializer());
            mapper.registerModule((Module)module);
            try {
                request = mapper.writeValueAsString((Object)this.spec.getParams());
            }
            catch (JsonProcessingException ex) {
                throw new IllegalArgumentException();
            }
            this.ws = this.newWebSocket(request);
            try {
                Object ex = this.condVar;
                synchronized (ex) {
                    this.condVar.wait(3000L);
                }
            }
            catch (InterruptedException ex) {
                throw new IllegalStateException();
            }
            return this.state == WsState.WS_START;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Object object = this.condVar;
            synchronized (object) {
                switch (this.state) {
                    case WS_INIT: 
                    case WS_STOP: {
                        throw new IllegalStateException(this.state.toString());
                    }
                }
                this.ws.close(1000, null);
                this.ws = null;
                this.state = WsState.WS_STOP;
            }
        }

        private class WebSocketListenerImpl
        extends WebSocketListener {
            private final String request;

            WebSocketListenerImpl(String request) {
                this.request = request;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                Object object = HttpMonitor.this.condVar;
                synchronized (object) {
                    HttpMonitor.this.state = WsState.WS_CONNECT;
                }
                webSocket.send(this.request);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(WebSocket webSocket, String message) {
                super.onMessage(webSocket, message);
                Object object = HttpMonitor.this.condVar;
                synchronized (object) {
                    switch (HttpMonitor.this.state) {
                        case WS_CONNECT: {
                            try {
                                RpcError error = (RpcError)HttpMonitor.this.mapper.readValue(message, RpcError.class);
                                if (error.getCode() == 0L) {
                                    HttpMonitor.this.state = WsState.WS_START;
                                    HttpMonitor.this.listener.onStart();
                                } else {
                                    HttpMonitor.this.listener.onError(error.getCode());
                                }
                            }
                            catch (IOException ex) {
                                HttpMonitor.this.listener.onError(100L);
                            }
                            HttpMonitor.this.condVar.notify();
                            break;
                        }
                        case WS_START: {
                            try {
                                RpcItem rpcItem = (RpcItem)HttpMonitor.this.mapper.readValue(message, RpcItem.class);
                                RpcObject rpcObj = rpcItem.asObject();
                                RpcItem value = rpcObj.getItem("progress");
                                if (value != null) {
                                    HttpMonitor.this.listener.onProgress(value.asInteger());
                                    break;
                                }
                                Object obj = HttpMonitor.this.rpcConverter.convertTo(rpcObj);
                                HttpMonitor.this.listener.onEvent(obj);
                            }
                            catch (IOException ex) {
                                HttpMonitor.this.listener.onError(100L);
                            }
                            break;
                        }
                    }
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                HttpMonitor.this.listener.onError(0L);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                HttpMonitor.this.listener.onClose();
            }
        }
    }

    private static enum WsState {
        WS_INIT,
        WS_REQUEST,
        WS_CONNECT,
        WS_START,
        WS_STOP;

    }

    private class Parser {
        private final String input;

        Parser(String s) {
            this.input = s;
        }

        void parse(boolean allowPath) {
            try {
                URI uri = new URI(this.input);
                if (allowPath) {
                    HttpProvider.this.channel = this.getChannel(uri.getPath());
                } else {
                    if (!"".equals(uri.getPath())) {
                        throw new IllegalArgumentException("Path is not allowed");
                    }
                    HttpProvider.this.channel = "";
                }
                HttpProvider.this.serverUri = uri.getScheme() + "://" + uri.getAuthority();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        private String getChannel(String path) {
            String[] tokens = path.replaceFirst("/$", "").split("/(?=[^/]+$)");
            if ("/api/v3".equals(tokens[0])) {
                return tokens[1];
            }
            if ("/api".equals(tokens[0]) && "v3".equals(tokens[1])) {
                return "";
            }
            throw new IllegalArgumentException("Invalid URI path");
        }
    }
}

