/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import foundation.icon.icx.transport.jsonrpc.RpcItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RpcArray
implements RpcItem,
Iterable<RpcItem> {
    private final List<RpcItem> items;

    private RpcArray(List<RpcItem> items) {
        this.items = items;
    }

    @Override
    public Iterator<RpcItem> iterator() {
        return this.items.iterator();
    }

    public RpcItem get(int index) {
        return this.items.get(index);
    }

    public int size() {
        return this.items.size();
    }

    public List<RpcItem> asList() {
        return new ArrayList<RpcItem>(this.items);
    }

    public String toString() {
        return "RpcArray(items=" + this.items + ')';
    }

    @Override
    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RpcArray)) {
            return false;
        }
        RpcArray obj = (RpcArray)o;
        return this.items.equals(obj.items);
    }

    public static class Builder {
        private final List<RpcItem> items = new ArrayList<RpcItem>();

        public Builder add(RpcItem item) {
            this.items.add(item);
            return this;
        }

        public RpcArray build() {
            return new RpcArray(this.items);
        }
    }
}

